/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.proxy.impl;

import com.google.common.collect.Lists;
import io.atomix.protocols.raft.cluster.MemberId;
import io.atomix.protocols.raft.proxy.CommunicationStrategy;
import io.atomix.protocols.raft.proxy.impl.MemberSelector;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;

public final class MemberSelectorManager {
    private final Set<MemberSelector> selectors = new CopyOnWriteArraySet<MemberSelector>();
    private final Set<Consumer<MemberId>> leaderChangeListeners = new CopyOnWriteArraySet<Consumer<MemberId>>();
    private volatile MemberId leader;
    private volatile Collection<MemberId> members = Collections.emptyList();

    public void addLeaderChangeListener(Consumer<MemberId> listener) {
        this.leaderChangeListeners.add(listener);
    }

    public void removeLeaderChangeListener(Consumer<MemberId> listener) {
        this.leaderChangeListeners.remove(listener);
    }

    public MemberId leader() {
        return this.leader;
    }

    public Collection<MemberId> members() {
        return this.members;
    }

    public MemberSelector createSelector(CommunicationStrategy selectionStrategy) {
        MemberSelector selector = new MemberSelector(this.leader, this.members, selectionStrategy, this);
        this.selectors.add(selector);
        return selector;
    }

    public void resetAll() {
        this.selectors.forEach(MemberSelector::reset);
    }

    public void resetAll(MemberId leader, Collection<MemberId> members) {
        MemberId oldLeader = this.leader;
        this.leader = leader;
        this.members = Lists.newLinkedList(members);
        this.selectors.forEach(s -> s.reset(leader, this.members));
        if (!Objects.equals(oldLeader, leader)) {
            this.leaderChangeListeners.forEach(l -> l.accept(leader));
        }
    }

    void remove(MemberSelector selector) {
        this.selectors.remove(selector);
    }
}

