/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.partition.impl;

import io.atomix.cluster.ClusterMembershipEventListener;
import io.atomix.cluster.ClusterMembershipService;
import io.atomix.primitive.partition.ManagedMemberGroupService;
import io.atomix.primitive.partition.MemberGroup;
import io.atomix.primitive.partition.MemberGroupEvent;
import io.atomix.primitive.partition.MemberGroupEventListener;
import io.atomix.primitive.partition.MemberGroupProvider;
import io.atomix.primitive.partition.MemberGroupService;
import io.atomix.utils.event.AbstractListenerManager;
import io.atomix.utils.event.EventListener;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;

public class DefaultMemberGroupService
extends AbstractListenerManager<MemberGroupEvent, MemberGroupEventListener>
implements ManagedMemberGroupService {
    private final AtomicBoolean started = new AtomicBoolean();
    private final ClusterMembershipService membershipService;
    private final MemberGroupProvider memberGroupProvider;
    private final ClusterMembershipEventListener membershipEventListener = event -> this.recomputeGroups();
    private volatile Collection<MemberGroup> memberGroups;

    public DefaultMemberGroupService(ClusterMembershipService membershipService, MemberGroupProvider memberGroupProvider) {
        this.membershipService = membershipService;
        this.memberGroupProvider = memberGroupProvider;
    }

    @Override
    public Collection<MemberGroup> getMemberGroups() {
        return this.memberGroups;
    }

    private void recomputeGroups() {
        this.memberGroups = this.memberGroupProvider.getMemberGroups(this.membershipService.getMembers());
    }

    public CompletableFuture<MemberGroupService> start() {
        if (this.started.compareAndSet(false, true)) {
            this.memberGroups = this.memberGroupProvider.getMemberGroups(this.membershipService.getMembers());
            this.membershipService.addListener((EventListener)this.membershipEventListener);
        }
        return CompletableFuture.completedFuture(this);
    }

    public boolean isRunning() {
        return this.started.get();
    }

    public CompletableFuture<Void> stop() {
        if (this.started.compareAndSet(true, false)) {
            this.membershipService.removeListener((EventListener)this.membershipEventListener);
        }
        return CompletableFuture.completedFuture(null);
    }
}

