/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.session.impl;

import com.google.common.base.Throwables;
import io.atomix.primitive.PrimitiveException;
import io.atomix.primitive.PrimitiveState;
import io.atomix.primitive.operation.PrimitiveOperation;
import io.atomix.primitive.session.SessionClient;
import io.atomix.primitive.session.impl.DelegatingSessionClient;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.concurrent.Scheduler;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import java.net.ConnectException;
import java.nio.channels.ClosedChannelException;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import org.slf4j.Logger;

public class RetryingSessionClient
extends DelegatingSessionClient {
    private final Logger log;
    private final SessionClient session;
    private final Scheduler scheduler;
    private final int maxRetries;
    private final Duration delayBetweenRetries;
    private final Predicate<Throwable> retryableCheck = e -> e instanceof ConnectException || e instanceof TimeoutException || e instanceof ClosedChannelException || e instanceof PrimitiveException.Unavailable || e instanceof PrimitiveException.Timeout || e instanceof PrimitiveException.QueryFailure || e instanceof PrimitiveException.UnknownClient || e instanceof PrimitiveException.UnknownSession || e instanceof PrimitiveException.ClosedSession;

    public RetryingSessionClient(SessionClient session, Scheduler scheduler, int maxRetries, Duration delayBetweenRetries) {
        super(session);
        this.session = session;
        this.scheduler = scheduler;
        this.maxRetries = maxRetries;
        this.delayBetweenRetries = delayBetweenRetries;
        this.log = ContextualLoggerFactory.getLogger(this.getClass(), (LoggerContext)LoggerContext.builder(SessionClient.class).addValue((Object)this.session.sessionId()).add("type", (Object)this.session.type()).add("name", (Object)this.session.name()).build());
    }

    @Override
    public CompletableFuture<byte[]> execute(PrimitiveOperation operation) {
        if (this.getState() == PrimitiveState.CLOSED) {
            return Futures.exceptionalFuture((Throwable)((Object)new PrimitiveException.ClosedSession()));
        }
        CompletableFuture<byte[]> future = new CompletableFuture<byte[]>();
        this.execute(operation, 1, future);
        return future;
    }

    private void execute(PrimitiveOperation operation, int attemptIndex, CompletableFuture<byte[]> future) {
        this.session.execute(operation).whenComplete((r, e) -> {
            if (e != null) {
                if (attemptIndex < this.maxRetries + 1 && this.retryableCheck.test(Throwables.getRootCause((Throwable)e))) {
                    this.log.debug("Retry attempt ({} of {}). Failure due to {}", new Object[]{attemptIndex, this.maxRetries, Throwables.getRootCause((Throwable)e).getClass()});
                    this.scheduler.schedule(this.delayBetweenRetries.multipliedBy(2 ^ attemptIndex), () -> this.execute(operation, attemptIndex + 1, future));
                } else {
                    future.completeExceptionally((Throwable)e);
                }
            } else {
                future.complete((byte[])r);
            }
        });
    }
}

