/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.session.impl;

import io.atomix.primitive.operation.OperationId;
import io.atomix.primitive.service.AbstractPrimitiveService;
import io.atomix.primitive.service.BackupInput;
import io.atomix.primitive.service.BackupOutput;
import io.atomix.primitive.service.ServiceExecutor;
import io.atomix.primitive.session.impl.SessionIdGeneratorOperations;
import io.atomix.primitive.session.impl.SessionIdGeneratorType;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Serializer;

public class SessionIdGeneratorService
extends AbstractPrimitiveService {
    private static final Serializer SERIALIZER = Serializer.using((Namespace)Namespace.builder().register(SessionIdGeneratorOperations.NAMESPACE).build());
    private long id;

    public SessionIdGeneratorService() {
        super(SessionIdGeneratorType.instance());
    }

    @Override
    public Serializer serializer() {
        return SERIALIZER;
    }

    @Override
    public void backup(BackupOutput writer) {
        writer.writeLong(this.id);
    }

    @Override
    public void restore(BackupInput reader) {
        this.id = reader.readLong();
    }

    @Override
    protected void configure(ServiceExecutor executor) {
        executor.register((OperationId)SessionIdGeneratorOperations.NEXT, this::next);
    }

    protected long next() {
        return ++this.id;
    }
}

