/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive;

import com.google.common.collect.Maps;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.PrimitiveTypes;
import io.atomix.utils.ConfigurationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class PrimitiveTypeRegistry {
    private final Map<String, PrimitiveType> types = Maps.newConcurrentMap();

    public PrimitiveTypeRegistry() {
        this(new ArrayList<Class<? extends PrimitiveType>>());
    }

    public PrimitiveTypeRegistry(Collection<Class<? extends PrimitiveType>> types) {
        for (PrimitiveType primitiveType : PrimitiveTypes.getPrimitiveTypes()) {
            this.types.put(primitiveType.id(), primitiveType);
        }
        for (Class clazz : types) {
            try {
                PrimitiveType type = (PrimitiveType)clazz.newInstance();
                this.types.put(type.id(), type);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new ConfigurationException("Failed to instantiate primitive type", (Throwable)e);
            }
        }
    }

    public void register(PrimitiveType type) {
        this.types.put(type.id(), type);
    }

    public void unregister(PrimitiveType type) {
        this.types.remove(type.id());
    }

    public PrimitiveType get(String typeName) {
        return this.types.get(typeName);
    }

    public int size() {
        return this.types.size();
    }
}

