/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive;

import com.google.common.base.Preconditions;
import io.atomix.primitive.DistributedPrimitive;
import io.atomix.primitive.PrimitiveConfig;
import io.atomix.primitive.PrimitiveManagementService;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.primitive.protocol.PrimitiveProtocolConfig;
import io.atomix.primitive.protocol.PrimitiveProtocols;
import io.atomix.utils.Builder;
import io.atomix.utils.serializer.KryoNamespace;
import io.atomix.utils.serializer.KryoNamespaces;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Serializer;
import io.atomix.utils.serializer.SerializerConfig;
import java.util.concurrent.CompletableFuture;

public abstract class DistributedPrimitiveBuilder<B extends DistributedPrimitiveBuilder<B, C, P>, C extends PrimitiveConfig, P extends DistributedPrimitive>
implements Builder<P> {
    private final PrimitiveType type;
    protected final String name;
    protected final C config;
    protected Serializer serializer;
    protected PrimitiveProtocol protocol;
    protected final PrimitiveManagementService managementService;

    public DistributedPrimitiveBuilder(PrimitiveType type, String name, C config, PrimitiveManagementService managementService) {
        this.type = (PrimitiveType)Preconditions.checkNotNull((Object)type, (Object)"type cannot be null");
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        this.config = (PrimitiveConfig)Preconditions.checkNotNull(config, (Object)"config cannot be null");
        this.managementService = (PrimitiveManagementService)Preconditions.checkNotNull((Object)managementService, (Object)"managementService cannot be null");
    }

    public B withSerializer(Serializer serializer) {
        this.serializer = serializer;
        return (B)this;
    }

    public B withProtocol(PrimitiveProtocol protocol) {
        this.protocol = protocol;
        return (B)this;
    }

    public B withCacheEnabled() {
        ((PrimitiveConfig)this.config).setCacheEnabled();
        return (B)this;
    }

    public B withCacheEnabled(boolean cacheEnabled) {
        ((PrimitiveConfig)this.config).setCacheEnabled(cacheEnabled);
        return (B)this;
    }

    public B withCacheSize(int cacheSize) {
        ((PrimitiveConfig)this.config).setCacheSize(cacheSize);
        return (B)this;
    }

    public B withReadOnly() {
        ((PrimitiveConfig)this.config).setReadOnly();
        return (B)this;
    }

    public B withReadOnly(boolean readOnly) {
        ((PrimitiveConfig)this.config).setReadOnly(readOnly);
        return (B)this;
    }

    public String name() {
        return this.name;
    }

    public PrimitiveType primitiveType() {
        return this.type;
    }

    public PrimitiveProtocol protocol() {
        PrimitiveProtocol protocol = this.protocol;
        if (protocol == null) {
            PrimitiveProtocolConfig protocolConfig = ((PrimitiveConfig)this.config).getProtocolConfig();
            protocol = protocolConfig == null ? this.managementService.getPartitionService().getDefaultPartitionGroup().newProtocol() : PrimitiveProtocols.createProtocol(protocolConfig);
        }
        return protocol;
    }

    public Serializer serializer() {
        Serializer serializer = this.serializer;
        if (serializer == null) {
            SerializerConfig config = ((PrimitiveConfig)this.config).getSerializerConfig();
            serializer = config == null ? Serializer.using((Namespace)KryoNamespaces.BASIC) : Serializer.using((Namespace)KryoNamespace.builder().register(KryoNamespaces.BASIC).register(new KryoNamespace(config)).build());
        }
        return serializer;
    }

    public P build() {
        return (P)((DistributedPrimitive)this.buildAsync().join());
    }

    public abstract CompletableFuture<P> buildAsync();
}

