/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.proxy.impl;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.event.EventType;
import io.atomix.primitive.event.PrimitiveEvent;
import io.atomix.primitive.operation.PrimitiveOperation;
import io.atomix.primitive.proxy.PrimitiveProxy;
import io.atomix.primitive.session.SessionId;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;

public class DelegatingPrimitiveProxy
implements PrimitiveProxy {
    private final PrimitiveProxy proxy;
    private final Map<String, Map<Object, Consumer<PrimitiveEvent>>> eventTypeListeners = Maps.newConcurrentMap();

    public DelegatingPrimitiveProxy(PrimitiveProxy proxy) {
        this.proxy = proxy;
    }

    @Override
    public SessionId sessionId() {
        return this.proxy.sessionId();
    }

    @Override
    public String name() {
        return this.proxy.name();
    }

    @Override
    public PrimitiveType serviceType() {
        return this.proxy.serviceType();
    }

    @Override
    public PrimitiveProxy.State getState() {
        return this.proxy.getState();
    }

    @Override
    public void addStateChangeListener(Consumer<PrimitiveProxy.State> listener) {
        this.proxy.addStateChangeListener(listener);
    }

    @Override
    public void removeStateChangeListener(Consumer<PrimitiveProxy.State> listener) {
        this.proxy.removeStateChangeListener(listener);
    }

    @Override
    public CompletableFuture<byte[]> execute(PrimitiveOperation operation) {
        return this.proxy.execute(operation);
    }

    @Override
    public void addEventListener(Consumer<PrimitiveEvent> listener) {
        this.proxy.addEventListener(listener);
    }

    @Override
    public void removeEventListener(Consumer<PrimitiveEvent> listener) {
        this.proxy.removeEventListener(listener);
    }

    @Override
    public void addEventListener(EventType eventType, Runnable listener) {
        Consumer<PrimitiveEvent> wrappedListener = e -> {
            if (((String)((Object)e.type().id())).equals(eventType.id())) {
                listener.run();
            }
        };
        this.eventTypeListeners.computeIfAbsent((String)((Object)eventType.id()), e -> Maps.newConcurrentMap()).put(listener, wrappedListener);
        this.addEventListener(wrappedListener);
    }

    @Override
    public void addEventListener(EventType eventType, Consumer<byte[]> listener) {
        Consumer<PrimitiveEvent> wrappedListener = e -> {
            if (((String)((Object)e.type().id())).equals(eventType.id())) {
                listener.accept(e.value());
            }
        };
        this.eventTypeListeners.computeIfAbsent((String)((Object)eventType.id()), e -> Maps.newConcurrentMap()).put(listener, wrappedListener);
        this.addEventListener(wrappedListener);
    }

    @Override
    public <T> void addEventListener(EventType eventType, Function<byte[], T> decoder, Consumer<T> listener) {
        Consumer<PrimitiveEvent> wrappedListener = e -> {
            if (((String)((Object)e.type().id())).equals(eventType.id())) {
                listener.accept(decoder.apply(e.value()));
            }
        };
        this.eventTypeListeners.computeIfAbsent((String)((Object)eventType.id()), e -> Maps.newConcurrentMap()).put(listener, wrappedListener);
        this.addEventListener(wrappedListener);
    }

    @Override
    public void removeEventListener(EventType eventType, Runnable listener) {
        Consumer eventListener = (Consumer)this.eventTypeListeners.computeIfAbsent((String)((Object)eventType.id()), e -> Maps.newConcurrentMap()).remove(listener);
        this.removeEventListener(eventListener);
    }

    @Override
    public void removeEventListener(EventType eventType, Consumer listener) {
        Consumer eventListener = (Consumer)this.eventTypeListeners.computeIfAbsent((String)((Object)eventType.id()), e -> Maps.newConcurrentMap()).remove(listener);
        this.removeEventListener(eventListener);
    }

    @Override
    public CompletableFuture<PrimitiveProxy> connect() {
        return this.proxy.connect().thenApply(c -> this);
    }

    @Override
    public CompletableFuture<Void> close() {
        return this.proxy.close();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("client", (Object)this.proxy).toString();
    }
}

