/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.proxy.impl;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import io.atomix.primitive.event.EventType;
import io.atomix.primitive.event.PrimitiveEvent;
import io.atomix.primitive.proxy.PrimitiveProxy;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class AbstractPrimitiveProxy
implements PrimitiveProxy {
    private final Map<EventType, Map<Object, Consumer<PrimitiveEvent>>> eventTypeListeners = Maps.newConcurrentMap();

    @Override
    public void addEventListener(EventType eventType, Runnable listener) {
        Consumer<PrimitiveEvent> wrappedListener = e -> {
            if (e.type().equals(eventType)) {
                listener.run();
            }
        };
        this.eventTypeListeners.computeIfAbsent(eventType, e -> Maps.newConcurrentMap()).put(listener, wrappedListener);
        this.addEventListener(wrappedListener);
    }

    @Override
    public void addEventListener(EventType eventType, Consumer<byte[]> listener) {
        Consumer<PrimitiveEvent> wrappedListener = e -> {
            if (e.type().equals(eventType)) {
                listener.accept(e.value());
            }
        };
        this.eventTypeListeners.computeIfAbsent(eventType, e -> Maps.newConcurrentMap()).put(listener, wrappedListener);
        this.addEventListener(wrappedListener);
    }

    @Override
    public <T> void addEventListener(EventType eventType, Function<byte[], T> decoder, Consumer<T> listener) {
        Consumer<PrimitiveEvent> wrappedListener = e -> {
            if (e.type().equals(eventType)) {
                listener.accept(decoder.apply(e.value()));
            }
        };
        this.eventTypeListeners.computeIfAbsent(eventType, e -> Maps.newConcurrentMap()).put(listener, wrappedListener);
        this.addEventListener(wrappedListener);
    }

    @Override
    public void removeEventListener(EventType eventType, Runnable listener) {
        Consumer eventListener = (Consumer)this.eventTypeListeners.computeIfAbsent(eventType, e -> Maps.newConcurrentMap()).remove(listener);
        this.removeEventListener(eventListener);
    }

    @Override
    public void removeEventListener(EventType eventType, Consumer listener) {
        Consumer eventListener = (Consumer)this.eventTypeListeners.computeIfAbsent(eventType, e -> Maps.newConcurrentMap()).remove(listener);
        this.removeEventListener(eventListener);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("session", (Object)this.sessionId()).toString();
    }
}

