/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.backup.partition;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.atomix.primitive.Recovery;
import io.atomix.primitive.Replication;
import io.atomix.primitive.partition.ManagedPartitionGroup;
import io.atomix.primitive.partition.MemberGroupProvider;
import io.atomix.primitive.partition.MemberGroupStrategy;
import io.atomix.primitive.partition.Partition;
import io.atomix.primitive.partition.PartitionGroup;
import io.atomix.primitive.partition.PartitionGroupConfig;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.partition.PartitionManagementService;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.primitive.protocol.ProxyProtocol;
import io.atomix.protocols.backup.MultiPrimaryProtocol;
import io.atomix.protocols.backup.partition.PrimaryBackupPartition;
import io.atomix.protocols.backup.partition.PrimaryBackupPartitionGroupConfig;
import io.atomix.utils.concurrent.BlockingAwareThreadPoolContextFactory;
import io.atomix.utils.concurrent.ThreadContextFactory;
import io.atomix.utils.serializer.Namespace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimaryBackupPartitionGroup
implements ManagedPartitionGroup {
    public static final Type TYPE = new Type();
    private static final Logger LOGGER = LoggerFactory.getLogger(PrimaryBackupPartitionGroup.class);
    private final String name;
    private final PrimaryBackupPartitionGroupConfig config;
    private final Map<PartitionId, PrimaryBackupPartition> partitions = Maps.newConcurrentMap();
    private final List<PartitionId> sortedPartitionIds = Lists.newCopyOnWriteArrayList();
    private ThreadContextFactory threadFactory;

    public static Builder builder(String name) {
        return new Builder((PrimaryBackupPartitionGroupConfig)new PrimaryBackupPartitionGroupConfig().setName(name));
    }

    private static Collection<PrimaryBackupPartition> buildPartitions(PrimaryBackupPartitionGroupConfig config) {
        ArrayList<PrimaryBackupPartition> partitions = new ArrayList<PrimaryBackupPartition>(config.getPartitions());
        for (int i = 0; i < config.getPartitions(); ++i) {
            partitions.add(new PrimaryBackupPartition(PartitionId.from((String)config.getName(), (int)(i + 1)), (MemberGroupProvider)config.getMemberGroupProvider()));
        }
        return partitions;
    }

    public PrimaryBackupPartitionGroup(PrimaryBackupPartitionGroupConfig config) {
        this.config = config;
        this.name = (String)Preconditions.checkNotNull((Object)config.getName());
        PrimaryBackupPartitionGroup.buildPartitions(config).forEach(p -> {
            this.partitions.put(p.id(), (PrimaryBackupPartition)p);
            this.sortedPartitionIds.add(p.id());
        });
        Collections.sort(this.sortedPartitionIds);
    }

    public String name() {
        return this.name;
    }

    public PartitionGroup.Type type() {
        return TYPE;
    }

    public PrimitiveProtocol.Type protocol() {
        return MultiPrimaryProtocol.TYPE;
    }

    public PartitionGroupConfig config() {
        return this.config;
    }

    public ProxyProtocol newProtocol() {
        return MultiPrimaryProtocol.builder(this.name).withRecovery(Recovery.RECOVER).withBackups(2).withReplication(Replication.SYNCHRONOUS).build();
    }

    public PrimaryBackupPartition getPartition(PartitionId partitionId) {
        return this.partitions.get(partitionId);
    }

    public Collection<Partition> getPartitions() {
        return this.partitions.values();
    }

    public List<PartitionId> getPartitionIds() {
        return this.sortedPartitionIds;
    }

    public CompletableFuture<ManagedPartitionGroup> join(PartitionManagementService managementService) {
        int threadPoolSize = Math.max(Math.min(Runtime.getRuntime().availableProcessors() * 2, 32), 4);
        this.threadFactory = new BlockingAwareThreadPoolContextFactory("atomix-" + this.name() + "-%d", threadPoolSize, LOGGER);
        List<CompletableFuture> futures = this.partitions.values().stream().map(p -> p.join(managementService, this.threadFactory)).collect(Collectors.toList());
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).thenApply(v -> {
            LOGGER.info("Started");
            return this;
        });
    }

    public CompletableFuture<ManagedPartitionGroup> connect(PartitionManagementService managementService) {
        int threadPoolSize = Math.max(Math.min(Runtime.getRuntime().availableProcessors() * 2, 32), 4);
        this.threadFactory = new BlockingAwareThreadPoolContextFactory("atomix-" + this.name() + "-%d", threadPoolSize, LOGGER);
        List<CompletableFuture> futures = this.partitions.values().stream().map(p -> p.connect(managementService, this.threadFactory)).collect(Collectors.toList());
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).thenApply(v -> {
            LOGGER.info("Started");
            return this;
        });
    }

    public CompletableFuture<Void> close() {
        List<CompletableFuture> futures = this.partitions.values().stream().map(PrimaryBackupPartition::close).collect(Collectors.toList());
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).whenCompleteAsync((r, e) -> {
            ThreadContextFactory threadFactory = this.threadFactory;
            if (threadFactory != null) {
                threadFactory.close();
            }
            LOGGER.info("Stopped");
        });
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("partitions", this.partitions).toString();
    }

    public static class Builder
    extends PartitionGroup.Builder<PrimaryBackupPartitionGroupConfig> {
        protected Builder(PrimaryBackupPartitionGroupConfig config) {
            super((PartitionGroupConfig)config);
        }

        public Builder withNumPartitions(int numPartitions) {
            ((PrimaryBackupPartitionGroupConfig)this.config).setPartitions(numPartitions);
            return this;
        }

        public Builder withMemberGroupStrategy(MemberGroupStrategy memberGroupStrategy) {
            ((PrimaryBackupPartitionGroupConfig)this.config).setMemberGroupStrategy(memberGroupStrategy);
            return this;
        }

        public PrimaryBackupPartitionGroup build() {
            return new PrimaryBackupPartitionGroup((PrimaryBackupPartitionGroupConfig)this.config);
        }
    }

    public static class Type
    implements PartitionGroup.Type<PrimaryBackupPartitionGroupConfig> {
        private static final String NAME = "primary-backup";

        public String name() {
            return NAME;
        }

        public Namespace namespace() {
            return Namespace.builder().nextId(700).register(new Class[]{PrimaryBackupPartitionGroupConfig.class}).build();
        }

        public PrimaryBackupPartitionGroupConfig newConfig() {
            return new PrimaryBackupPartitionGroupConfig();
        }

        public ManagedPartitionGroup newPartitionGroup(PrimaryBackupPartitionGroupConfig config) {
            return new PrimaryBackupPartitionGroup(config);
        }
    }
}

