/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.backup.proxy;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import io.atomix.cluster.ClusterEvent;
import io.atomix.cluster.ClusterEventListener;
import io.atomix.cluster.ClusterService;
import io.atomix.cluster.Node;
import io.atomix.primitive.PrimitiveException;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.event.PrimitiveEvent;
import io.atomix.primitive.operation.PrimitiveOperation;
import io.atomix.primitive.partition.PrimaryElection;
import io.atomix.primitive.partition.PrimaryElectionEventListener;
import io.atomix.primitive.partition.PrimaryTerm;
import io.atomix.primitive.proxy.PrimitiveProxy;
import io.atomix.primitive.proxy.impl.AbstractPrimitiveProxy;
import io.atomix.primitive.session.SessionId;
import io.atomix.protocols.backup.protocol.CloseRequest;
import io.atomix.protocols.backup.protocol.ExecuteRequest;
import io.atomix.protocols.backup.protocol.PrimaryBackupClientProtocol;
import io.atomix.protocols.backup.protocol.PrimaryBackupResponse;
import io.atomix.protocols.backup.protocol.PrimitiveDescriptor;
import io.atomix.utils.concurrent.ComposableFuture;
import io.atomix.utils.concurrent.ThreadContext;
import io.atomix.utils.event.EventListener;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import java.net.ConnectException;
import java.time.Duration;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.slf4j.Logger;

public class PrimaryBackupProxy
extends AbstractPrimitiveProxy {
    private static final int RETRY_DELAY = 100;
    private Logger log;
    private final PrimitiveType primitiveType;
    private final PrimitiveDescriptor descriptor;
    private final ClusterService clusterService;
    private final PrimaryBackupClientProtocol protocol;
    private final SessionId sessionId;
    private final PrimaryElection primaryElection;
    private final ThreadContext threadContext;
    private final Set<Consumer<PrimitiveProxy.State>> stateChangeListeners = Sets.newIdentityHashSet();
    private final Set<Consumer<PrimitiveEvent>> eventListeners = Sets.newIdentityHashSet();
    private final PrimaryElectionEventListener primaryElectionListener = event -> this.changeReplicas(event.term());
    private final ClusterEventListener clusterEventListener = this::handleClusterEvent;
    private PrimaryTerm term;
    private volatile PrimitiveProxy.State state = PrimitiveProxy.State.CLOSED;

    public PrimaryBackupProxy(String clientName, SessionId sessionId, PrimitiveType primitiveType, PrimitiveDescriptor descriptor, ClusterService clusterService, PrimaryBackupClientProtocol protocol, PrimaryElection primaryElection, ThreadContext threadContext) {
        this.sessionId = (SessionId)Preconditions.checkNotNull((Object)sessionId);
        this.primitiveType = primitiveType;
        this.descriptor = descriptor;
        this.clusterService = clusterService;
        this.protocol = protocol;
        this.primaryElection = primaryElection;
        this.threadContext = threadContext;
        primaryElection.addListener((EventListener)this.primaryElectionListener);
        this.log = ContextualLoggerFactory.getLogger(((Object)((Object)this)).getClass(), (LoggerContext)LoggerContext.builder(PrimitiveProxy.class).addValue((Object)clientName).add("type", (Object)primitiveType.id()).add("name", (Object)descriptor.name()).build());
    }

    public SessionId sessionId() {
        return this.sessionId;
    }

    public String name() {
        return this.descriptor.name();
    }

    public PrimitiveType serviceType() {
        return this.primitiveType;
    }

    public PrimitiveProxy.State getState() {
        return this.state;
    }

    public void addStateChangeListener(Consumer<PrimitiveProxy.State> listener) {
        this.stateChangeListeners.add(listener);
    }

    public void removeStateChangeListener(Consumer<PrimitiveProxy.State> listener) {
        this.stateChangeListeners.remove(listener);
    }

    public CompletableFuture<byte[]> execute(PrimitiveOperation operation) {
        ComposableFuture future = new ComposableFuture();
        this.threadContext.execute(() -> {
            if (this.term.primary() == null) {
                this.primaryElection.getTerm().whenCompleteAsync((term, error) -> {
                    if (error == null) {
                        if (term.term() <= this.term.term() || term.primary() == null) {
                            future.completeExceptionally((Throwable)new PrimitiveException.Unavailable());
                        } else {
                            this.term = term;
                            this.execute(operation, (ComposableFuture<byte[]>)future);
                        }
                    } else {
                        future.completeExceptionally((Throwable)new PrimitiveException.Unavailable());
                    }
                }, (Executor)this.threadContext);
            } else {
                this.execute(operation, (ComposableFuture<byte[]>)future);
            }
        });
        return future;
    }

    private void execute(PrimitiveOperation operation, ComposableFuture<byte[]> future) {
        ExecuteRequest request = ExecuteRequest.request(this.descriptor, (Long)this.sessionId.id(), this.clusterService.getLocalNode().id(), operation);
        this.log.trace("Sending {} to {}", (Object)request, (Object)this.term.primary());
        PrimaryTerm term = this.term;
        if (term.primary() != null) {
            this.protocol.execute(term.primary().nodeId(), request).whenCompleteAsync((response, error) -> {
                if (error == null) {
                    this.log.trace("Received {}", response);
                    if (response.status() == PrimaryBackupResponse.Status.OK) {
                        future.complete((Object)response.result());
                    } else if (this.term.term() > term.term()) {
                        this.execute(operation).whenComplete((BiConsumer)future);
                    } else {
                        this.primaryElection.getTerm().whenComplete((newTerm, termError) -> {
                            if (termError == null) {
                                if (newTerm.term() > term.term() && newTerm.primary() != null) {
                                    this.execute(operation).whenComplete((BiConsumer)future);
                                } else {
                                    future.completeExceptionally((Throwable)new PrimitiveException.Unavailable());
                                }
                            } else {
                                future.completeExceptionally((Throwable)new PrimitiveException.Unavailable());
                            }
                        });
                    }
                } else {
                    Throwable cause = Throwables.getRootCause((Throwable)error);
                    if (cause instanceof PrimitiveException.Unavailable) {
                        this.threadContext.schedule(Duration.ofMillis(100L), () -> this.execute(operation, future));
                    } else {
                        future.completeExceptionally(error);
                    }
                }
            }, (Executor)this.threadContext);
        } else {
            future.completeExceptionally((Throwable)new ConnectException());
        }
    }

    public void addEventListener(Consumer<PrimitiveEvent> listener) {
        this.eventListeners.add(listener);
    }

    public void removeEventListener(Consumer<PrimitiveEvent> listener) {
        this.eventListeners.remove(listener);
    }

    private void changeReplicas(PrimaryTerm term) {
        this.threadContext.execute(() -> {
            if (this.term == null || term.term() > this.term.term()) {
                this.term = term;
            }
        });
    }

    private void handleClusterEvent(ClusterEvent event) {
        if (event.type() == ClusterEvent.Type.NODE_DEACTIVATED && ((Node)event.subject()).id().equals((Object)this.term.primary().nodeId())) {
            this.threadContext.execute(() -> {
                this.state = PrimitiveProxy.State.SUSPENDED;
                this.stateChangeListeners.forEach(l -> l.accept(this.state));
            });
        }
    }

    private void handleEvent(PrimitiveEvent event) {
        this.log.trace("Received {}", (Object)event);
        this.eventListeners.forEach(l -> l.accept(event));
    }

    public CompletableFuture<PrimitiveProxy> connect() {
        CompletableFuture<PrimitiveProxy> future = new CompletableFuture<PrimitiveProxy>();
        this.threadContext.execute(() -> this.primaryElection.getTerm().whenCompleteAsync((term, error) -> {
            if (error == null) {
                if (term.primary() == null) {
                    future.completeExceptionally((Throwable)new PrimitiveException.Unavailable());
                } else {
                    this.term = term;
                    this.protocol.registerEventListener(this.sessionId, this::handleEvent, (Executor)this.threadContext);
                    future.complete((PrimitiveProxy)this);
                }
            } else {
                future.completeExceptionally((Throwable)new PrimitiveException.Unavailable());
            }
        }, (Executor)this.threadContext));
        return future;
    }

    public CompletableFuture<Void> close() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (this.term.primary() != null) {
            this.protocol.close(this.term.primary().nodeId(), new CloseRequest(this.descriptor, (Long)this.sessionId.id())).whenCompleteAsync((response, error) -> {
                this.protocol.unregisterEventListener(this.sessionId);
                this.clusterService.removeListener((EventListener)this.clusterEventListener);
                this.primaryElection.removeListener((EventListener)this.primaryElectionListener);
                future.complete(null);
            }, (Executor)this.threadContext);
        } else {
            future.complete(null);
        }
        return future;
    }
}

