/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.backup;

import io.atomix.primitive.Consistency;
import io.atomix.primitive.Recovery;
import io.atomix.primitive.Replication;
import io.atomix.primitive.protocol.PrimitiveProtocolConfig;
import java.time.Duration;
import java.util.concurrent.Executor;

public class MultiPrimaryProtocolConfig
extends PrimitiveProtocolConfig<MultiPrimaryProtocolConfig> {
    private Consistency consistency = Consistency.SEQUENTIAL;
    private Replication replication = Replication.ASYNCHRONOUS;
    private Recovery recovery = Recovery.RECOVER;
    private int numBackups = 1;
    private int maxRetries = 0;
    private Duration retryDelay = Duration.ofMillis(100L);
    private Executor executor;

    public Consistency getConsistency() {
        return this.consistency;
    }

    public MultiPrimaryProtocolConfig setConsistency(Consistency consistency) {
        this.consistency = consistency;
        return this;
    }

    public Replication getReplication() {
        return this.replication;
    }

    public MultiPrimaryProtocolConfig setReplication(Replication replication) {
        this.replication = replication;
        return this;
    }

    public Recovery getRecovery() {
        return this.recovery;
    }

    public MultiPrimaryProtocolConfig setRecovery(Recovery recovery) {
        this.recovery = recovery;
        return this;
    }

    public int getNumBackups() {
        return this.numBackups;
    }

    public MultiPrimaryProtocolConfig setNumBackups(int numBackups) {
        this.numBackups = numBackups;
        return this;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public MultiPrimaryProtocolConfig setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }

    public Duration getRetryDelay() {
        return this.retryDelay;
    }

    public MultiPrimaryProtocolConfig setRetryDelayMillis(long retryDelayMillis) {
        return this.setRetryDelay(Duration.ofMillis(retryDelayMillis));
    }

    public MultiPrimaryProtocolConfig setRetryDelay(Duration retryDelay) {
        this.retryDelay = retryDelay;
        return this;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public MultiPrimaryProtocolConfig setExecutor(Executor executor) {
        this.executor = executor;
        return this;
    }
}

