/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.backup;

import com.google.common.base.MoreObjects;
import io.atomix.primitive.Consistency;
import io.atomix.primitive.Recovery;
import io.atomix.primitive.Replication;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.primitive.protocol.PrimitiveProtocolConfig;
import io.atomix.protocols.backup.MultiPrimaryProtocolConfig;
import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class MultiPrimaryProtocol
implements PrimitiveProtocol {
    public static final PrimitiveProtocol.Type TYPE = new PrimitiveProtocol.Type(){

        public String name() {
            return "multi-primary";
        }
    };
    private final MultiPrimaryProtocolConfig config;

    public static Builder builder() {
        return new Builder(new MultiPrimaryProtocolConfig());
    }

    public static Builder builder(String group) {
        return new Builder((MultiPrimaryProtocolConfig)new MultiPrimaryProtocolConfig().setGroup(group));
    }

    public MultiPrimaryProtocol(MultiPrimaryProtocolConfig config) {
        this.config = config;
    }

    public PrimitiveProtocol.Type type() {
        return TYPE;
    }

    public String group() {
        return this.config.getGroup();
    }

    public Consistency consistency() {
        return this.config.getConsistency();
    }

    public Replication replication() {
        return this.config.getReplication();
    }

    public Recovery recovery() {
        return this.config.getRecovery();
    }

    public int backups() {
        return this.config.getNumBackups();
    }

    public int maxRetries() {
        return this.config.getMaxRetries();
    }

    public Duration retryDelay() {
        return this.config.getRetryDelay();
    }

    public Executor executor() {
        return this.config.getExecutor();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type()).add("group", (Object)this.group()).add("consistency", (Object)this.consistency()).add("replication", (Object)this.replication()).add("backups", this.backups()).add("maxRetries", this.maxRetries()).add("retryDelay", (Object)this.retryDelay()).toString();
    }

    public static class Builder
    extends PrimitiveProtocol.Builder<MultiPrimaryProtocolConfig, MultiPrimaryProtocol> {
        protected Builder(MultiPrimaryProtocolConfig config) {
            super((PrimitiveProtocolConfig)config);
        }

        public Builder withConsistency(Consistency consistency) {
            ((MultiPrimaryProtocolConfig)this.config).setConsistency(consistency);
            return this;
        }

        public Builder withReplication(Replication replication) {
            ((MultiPrimaryProtocolConfig)this.config).setReplication(replication);
            return this;
        }

        public Builder withRecovery(Recovery recovery) {
            ((MultiPrimaryProtocolConfig)this.config).setRecovery(recovery);
            return this;
        }

        public Builder withBackups(int numBackups) {
            ((MultiPrimaryProtocolConfig)this.config).setNumBackups(numBackups);
            return this;
        }

        public Builder withMaxRetries(int maxRetries) {
            ((MultiPrimaryProtocolConfig)this.config).setMaxRetries(maxRetries);
            return this;
        }

        public Builder withRetryDelayMillis(long retryDelayMillis) {
            ((MultiPrimaryProtocolConfig)this.config).setRetryDelayMillis(retryDelayMillis);
            return this;
        }

        public Builder withRetryDelay(long retryDelay, TimeUnit timeUnit) {
            return this.withRetryDelay(Duration.ofMillis(timeUnit.toMillis(retryDelay)));
        }

        public Builder withRetryDelay(Duration retryDelay) {
            ((MultiPrimaryProtocolConfig)this.config).setRetryDelay(retryDelay);
            return this;
        }

        public Builder withExecutor(Executor executor) {
            ((MultiPrimaryProtocolConfig)this.config).setExecutor(executor);
            return this;
        }

        public MultiPrimaryProtocol build() {
            return new MultiPrimaryProtocol((MultiPrimaryProtocolConfig)this.config);
        }
    }
}

