/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.backup.service.impl;

import com.google.common.base.Preconditions;
import io.atomix.cluster.ClusterEvent;
import io.atomix.cluster.ClusterEventListener;
import io.atomix.cluster.ClusterService;
import io.atomix.cluster.Node;
import io.atomix.cluster.NodeId;
import io.atomix.primitive.PrimitiveId;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.operation.OperationType;
import io.atomix.primitive.partition.PrimaryElection;
import io.atomix.primitive.partition.PrimaryElectionEventListener;
import io.atomix.primitive.partition.PrimaryTerm;
import io.atomix.primitive.service.PrimitiveService;
import io.atomix.primitive.service.ServiceContext;
import io.atomix.primitive.session.Session;
import io.atomix.primitive.session.SessionId;
import io.atomix.primitive.session.SessionListener;
import io.atomix.protocols.backup.PrimaryBackupServer;
import io.atomix.protocols.backup.impl.PrimaryBackupSession;
import io.atomix.protocols.backup.protocol.BackupRequest;
import io.atomix.protocols.backup.protocol.BackupResponse;
import io.atomix.protocols.backup.protocol.CloseRequest;
import io.atomix.protocols.backup.protocol.CloseResponse;
import io.atomix.protocols.backup.protocol.ExecuteRequest;
import io.atomix.protocols.backup.protocol.ExecuteResponse;
import io.atomix.protocols.backup.protocol.PrimaryBackupServerProtocol;
import io.atomix.protocols.backup.protocol.PrimitiveDescriptor;
import io.atomix.protocols.backup.protocol.RestoreRequest;
import io.atomix.protocols.backup.protocol.RestoreResponse;
import io.atomix.protocols.backup.roles.BackupRole;
import io.atomix.protocols.backup.roles.NoneRole;
import io.atomix.protocols.backup.roles.PrimaryBackupRole;
import io.atomix.protocols.backup.roles.PrimaryRole;
import io.atomix.protocols.backup.service.impl.PrimaryBackupServiceSessions;
import io.atomix.utils.concurrent.ComposableFuture;
import io.atomix.utils.concurrent.ThreadContext;
import io.atomix.utils.event.EventListener;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import io.atomix.utils.time.LogicalClock;
import io.atomix.utils.time.LogicalTimestamp;
import io.atomix.utils.time.WallClock;
import io.atomix.utils.time.WallClockTimestamp;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.slf4j.Logger;

public class PrimaryBackupServiceContext
implements ServiceContext {
    private final Logger log;
    private final NodeId localNodeId;
    private final String serverName;
    private final PrimitiveId primitiveId;
    private final PrimitiveType primitiveType;
    private final PrimitiveDescriptor descriptor;
    private final PrimitiveService service;
    private final PrimaryBackupServiceSessions sessions = new PrimaryBackupServiceSessions();
    private final ThreadContext threadContext;
    private final ClusterService clusterService;
    private final PrimaryBackupServerProtocol protocol;
    private final PrimaryElection primaryElection;
    private NodeId primary;
    private List<NodeId> backups;
    private long currentTerm;
    private long currentIndex;
    private Session currentSession;
    private long currentTimestamp;
    private long operationIndex;
    private long commitIndex;
    private OperationType currentOperation = OperationType.COMMAND;
    private final LogicalClock logicalClock = new LogicalClock(){

        public LogicalTimestamp getTime() {
            return new LogicalTimestamp(PrimaryBackupServiceContext.this.operationIndex);
        }
    };
    private final WallClock wallClock = new WallClock(){

        public WallClockTimestamp getTime() {
            return WallClockTimestamp.from((long)PrimaryBackupServiceContext.this.currentTimestamp);
        }
    };
    private PrimaryBackupRole role;
    private final ClusterEventListener clusterEventListener = this::handleClusterEvent;
    private final PrimaryElectionEventListener primaryElectionListener = event -> this.changeRole(event.term());

    public PrimaryBackupServiceContext(String serverName, PrimitiveId primitiveId, PrimitiveType primitiveType, PrimitiveDescriptor descriptor, ThreadContext threadContext, ClusterService clusterService, PrimaryBackupServerProtocol protocol, PrimaryElection primaryElection) {
        this.localNodeId = clusterService.getLocalNode().id();
        this.serverName = (String)Preconditions.checkNotNull((Object)serverName);
        this.primitiveId = (PrimitiveId)Preconditions.checkNotNull((Object)primitiveId);
        this.primitiveType = (PrimitiveType)Preconditions.checkNotNull((Object)primitiveType);
        this.descriptor = (PrimitiveDescriptor)Preconditions.checkNotNull((Object)descriptor);
        this.service = primitiveType.newService();
        this.threadContext = (ThreadContext)Preconditions.checkNotNull((Object)threadContext);
        this.clusterService = (ClusterService)Preconditions.checkNotNull((Object)clusterService);
        this.protocol = (PrimaryBackupServerProtocol)Preconditions.checkNotNull((Object)protocol);
        this.primaryElection = (PrimaryElection)Preconditions.checkNotNull((Object)primaryElection);
        this.log = ContextualLoggerFactory.getLogger(this.getClass(), (LoggerContext)LoggerContext.builder(PrimitiveService.class).addValue((Object)serverName).add("type", (Object)descriptor.type()).add("name", (Object)descriptor.name()).build());
        clusterService.addListener((EventListener)this.clusterEventListener);
        primaryElection.addListener((EventListener)this.primaryElectionListener);
    }

    public CompletableFuture<Void> open() {
        return ((CompletableFuture)this.primaryElection.getTerm().thenAccept(this::changeRole)).thenRun(() -> {
            this.sessions.addListener((SessionListener)this.service);
            this.service.init((ServiceContext)this);
        });
    }

    public PrimaryBackupServer.Role getRole() {
        return this.role.role();
    }

    public PrimitiveId serviceId() {
        return this.primitiveId;
    }

    public PrimitiveDescriptor descriptor() {
        return this.descriptor;
    }

    public NodeId nodeId() {
        return this.localNodeId;
    }

    public String serverName() {
        return this.serverName;
    }

    public String serviceName() {
        return this.descriptor.name();
    }

    public PrimitiveType serviceType() {
        return this.primitiveType;
    }

    public long currentIndex() {
        return this.currentIndex;
    }

    public Session currentSession() {
        return this.currentSession;
    }

    public long currentTimestamp() {
        return this.currentTimestamp;
    }

    public long setTimestamp(long timestamp) {
        this.currentTimestamp = timestamp;
        this.service.tick(WallClockTimestamp.from((long)timestamp));
        return this.currentTimestamp;
    }

    public long currentTerm() {
        return this.currentTerm;
    }

    public void resetTerm(long term, NodeId primary) {
        this.currentTerm = term;
        this.primary = primary;
    }

    public long nextIndex() {
        this.currentOperation = OperationType.COMMAND;
        return ++this.operationIndex;
    }

    public boolean nextIndex(long index) {
        if (this.operationIndex + 1L == index) {
            this.currentOperation = OperationType.COMMAND;
            ++this.operationIndex;
            return true;
        }
        return false;
    }

    public void resetIndex(long index, long timestamp) {
        this.currentOperation = OperationType.COMMAND;
        this.operationIndex = index;
        this.currentIndex = index;
        this.currentTimestamp = timestamp;
    }

    public long setIndex(long index) {
        this.currentOperation = OperationType.COMMAND;
        this.currentIndex = index;
        return this.currentIndex;
    }

    public long getIndex() {
        this.currentOperation = OperationType.QUERY;
        return this.currentIndex;
    }

    public Session setSession(Session session) {
        this.currentSession = session;
        return session;
    }

    public long setCommitIndex(long commitIndex) {
        this.commitIndex = Math.max(this.commitIndex, commitIndex);
        return this.commitIndex;
    }

    public long getCommitIndex() {
        return this.commitIndex;
    }

    public OperationType currentOperation() {
        return this.currentOperation;
    }

    public LogicalClock logicalClock() {
        return this.logicalClock;
    }

    public WallClock wallClock() {
        return this.wallClock;
    }

    public PrimaryBackupServiceSessions sessions() {
        return this.sessions;
    }

    public NodeId primary() {
        return this.primary;
    }

    public List<NodeId> backups() {
        return this.backups;
    }

    public ThreadContext threadContext() {
        return this.threadContext;
    }

    public PrimaryBackupServerProtocol protocol() {
        return this.protocol;
    }

    public PrimitiveService service() {
        return this.service;
    }

    public CompletableFuture<ExecuteResponse> execute(ExecuteRequest request) {
        ComposableFuture future = new ComposableFuture();
        this.threadContext.execute(() -> this.role.execute(request).whenComplete((BiConsumer)future));
        return future;
    }

    public CompletableFuture<BackupResponse> backup(BackupRequest request) {
        ComposableFuture future = new ComposableFuture();
        this.threadContext.execute(() -> this.role.backup(request).whenComplete((BiConsumer)future));
        return future;
    }

    public CompletableFuture<RestoreResponse> restore(RestoreRequest request) {
        ComposableFuture future = new ComposableFuture();
        this.threadContext.execute(() -> this.role.restore(request).whenComplete((BiConsumer)future));
        return future;
    }

    public CompletableFuture<CloseResponse> close(CloseRequest request) {
        ComposableFuture future = new ComposableFuture();
        this.threadContext.execute(() -> {
            PrimaryBackupSession session = this.sessions.getSession(request.session());
            if (session != null) {
                this.role.close(session).whenComplete((result, error) -> {
                    if (error == null) {
                        future.complete((Object)CloseResponse.ok());
                    } else {
                        future.complete((Object)CloseResponse.error());
                    }
                });
            } else {
                future.complete((Object)CloseResponse.error());
            }
        });
        return future;
    }

    public PrimaryBackupSession getSession(long sessionId) {
        return this.sessions.getSession(sessionId);
    }

    public PrimaryBackupSession createSession(long sessionId, NodeId nodeId) {
        PrimaryBackupSession session = new PrimaryBackupSession(SessionId.from((long)sessionId), nodeId, this);
        this.sessions.openSession(session);
        return session;
    }

    public PrimaryBackupSession getOrCreateSession(long sessionId, NodeId nodeId) {
        PrimaryBackupSession session = this.sessions.getSession(sessionId);
        if (session == null) {
            session = this.createSession(sessionId, nodeId);
        }
        return session;
    }

    private void handleClusterEvent(ClusterEvent event) {
        if (event.type() == ClusterEvent.Type.NODE_DEACTIVATED) {
            Iterator<Session> iterator = this.sessions.iterator();
            while (iterator.hasNext()) {
                Session session = iterator.next();
                if (!session.nodeId().equals((Object)((Node)event.subject()).id())) continue;
                this.role.expire((PrimaryBackupSession)session);
            }
        }
    }

    private void changeRole(PrimaryTerm term) {
        if (term.term() > this.currentTerm) {
            this.log.trace("Term changed: {}", (Object)term);
            this.currentTerm = term.term();
            this.primary = term.primary();
            this.backups = term.backups().subList(0, Math.min(this.descriptor.backups(), term.backups().size()));
            if (this.backups.size() < this.descriptor.backups()) {
                if (this.role == null) {
                    this.log.warn("Not enough backups; transitioning to {}", (Object)PrimaryBackupServer.Role.NONE);
                    this.role = new NoneRole(this);
                    this.log.trace("{} transitioning to {}", (Object)this.clusterService.getLocalNode().id(), (Object)PrimaryBackupServer.Role.NONE);
                } else if (this.role.role() != PrimaryBackupServer.Role.NONE) {
                    this.log.warn("Not enough backups; transitioning to {}", (Object)PrimaryBackupServer.Role.NONE);
                    this.role.close();
                    this.role = new NoneRole(this);
                    this.log.trace("{} transitioning to {}", (Object)this.clusterService.getLocalNode().id(), (Object)PrimaryBackupServer.Role.NONE);
                }
            } else if (this.primary.equals((Object)this.clusterService.getLocalNode().id())) {
                if (this.role == null) {
                    this.role = new PrimaryRole(this);
                    this.log.trace("{} transitioning to {}", (Object)this.clusterService.getLocalNode().id(), (Object)PrimaryBackupServer.Role.PRIMARY);
                } else if (this.role.role() != PrimaryBackupServer.Role.PRIMARY) {
                    this.role.close();
                    this.role = new PrimaryRole(this);
                    this.log.trace("{} transitioning to {}", (Object)this.clusterService.getLocalNode().id(), (Object)PrimaryBackupServer.Role.PRIMARY);
                }
            } else if (this.backups.contains(this.clusterService.getLocalNode().id())) {
                if (this.role == null) {
                    this.role = new BackupRole(this);
                    this.log.trace("{} transitioning to {}", (Object)this.clusterService.getLocalNode().id(), (Object)PrimaryBackupServer.Role.BACKUP);
                } else if (this.role.role() != PrimaryBackupServer.Role.BACKUP) {
                    this.role.close();
                    this.role = new BackupRole(this);
                    this.log.trace("{} transitioning to {}", (Object)this.clusterService.getLocalNode().id(), (Object)PrimaryBackupServer.Role.BACKUP);
                }
            } else if (this.role == null) {
                this.role = new NoneRole(this);
                this.log.trace("{} transitioning to {}", (Object)this.clusterService.getLocalNode().id(), (Object)PrimaryBackupServer.Role.NONE);
            } else if (this.role.role() != PrimaryBackupServer.Role.NONE) {
                this.role.close();
                this.role = new NoneRole(this);
                this.log.trace("{} transitioning to {}", (Object)this.clusterService.getLocalNode().id(), (Object)PrimaryBackupServer.Role.NONE);
            }
        }
    }

    public CompletableFuture<Void> close() {
        this.clusterService.removeListener((EventListener)this.clusterEventListener);
        this.primaryElection.removeListener((EventListener)this.primaryElectionListener);
        return CompletableFuture.completedFuture(null);
    }
}

