/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.log.partition.impl;

import com.google.common.base.Preconditions;
import io.atomix.cluster.MemberId;
import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.atomix.protocols.log.partition.impl.LogMessageContext;
import io.atomix.protocols.log.protocol.AppendRequest;
import io.atomix.protocols.log.protocol.AppendResponse;
import io.atomix.protocols.log.protocol.BackupRequest;
import io.atomix.protocols.log.protocol.BackupResponse;
import io.atomix.protocols.log.protocol.ConsumeRequest;
import io.atomix.protocols.log.protocol.ConsumeResponse;
import io.atomix.protocols.log.protocol.LogServerProtocol;
import io.atomix.protocols.log.protocol.RecordsRequest;
import io.atomix.protocols.log.protocol.ResetRequest;
import io.atomix.utils.serializer.Serializer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;

public class LogServerCommunicator
implements LogServerProtocol {
    private final LogMessageContext context;
    private final Serializer serializer;
    private final ClusterCommunicationService clusterCommunicator;

    public LogServerCommunicator(String prefix, Serializer serializer, ClusterCommunicationService clusterCommunicator) {
        this.context = new LogMessageContext(prefix);
        this.serializer = (Serializer)Preconditions.checkNotNull((Object)serializer, (Object)"serializer cannot be null");
        this.clusterCommunicator = (ClusterCommunicationService)Preconditions.checkNotNull((Object)clusterCommunicator, (Object)"clusterCommunicator cannot be null");
    }

    private <T> void unicast(String subject, T request, MemberId memberId) {
        this.clusterCommunicator.unicast(subject, request, arg_0 -> ((Serializer)this.serializer).encode(arg_0), memberId, false);
    }

    private <T, U> CompletableFuture<U> send(String subject, T request, MemberId memberId) {
        return this.clusterCommunicator.send(subject, request, arg_0 -> ((Serializer)this.serializer).encode(arg_0), arg_0 -> ((Serializer)this.serializer).decode(arg_0), memberId);
    }

    @Override
    public void produce(MemberId memberId, String subject, RecordsRequest request) {
        this.unicast(subject, request, memberId);
    }

    @Override
    public CompletableFuture<BackupResponse> backup(MemberId memberId, BackupRequest request) {
        return this.send(this.context.backupSubject, request, memberId);
    }

    @Override
    public void registerBackupHandler(Function<BackupRequest, CompletableFuture<BackupResponse>> handler) {
        this.clusterCommunicator.subscribe(this.context.backupSubject, arg_0 -> ((Serializer)this.serializer).decode(arg_0), handler, arg_0 -> ((Serializer)this.serializer).encode(arg_0));
    }

    @Override
    public void unregisterBackupHandler() {
        this.clusterCommunicator.unsubscribe(this.context.backupSubject);
    }

    @Override
    public void registerAppendHandler(Function<AppendRequest, CompletableFuture<AppendResponse>> handler) {
        this.clusterCommunicator.subscribe(this.context.appendSubject, arg_0 -> ((Serializer)this.serializer).decode(arg_0), handler, arg_0 -> ((Serializer)this.serializer).encode(arg_0));
    }

    @Override
    public void unregisterAppendHandler() {
        this.clusterCommunicator.unsubscribe(this.context.appendSubject);
    }

    @Override
    public void registerConsumeHandler(Function<ConsumeRequest, CompletableFuture<ConsumeResponse>> handler) {
        this.clusterCommunicator.subscribe(this.context.consumeSubject, arg_0 -> ((Serializer)this.serializer).decode(arg_0), handler, arg_0 -> ((Serializer)this.serializer).encode(arg_0));
    }

    @Override
    public void unregisterConsumeHandler() {
        this.clusterCommunicator.unsubscribe(this.context.consumeSubject);
    }

    @Override
    public void registerResetConsumer(Consumer<ResetRequest> consumer, Executor executor) {
        this.clusterCommunicator.subscribe(this.context.resetSubject, arg_0 -> ((Serializer)this.serializer).decode(arg_0), consumer, executor);
    }

    @Override
    public void unregisterResetConsumer() {
        this.clusterCommunicator.unsubscribe(this.context.resetSubject);
    }
}

