/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.log.partition.impl;

import io.atomix.primitive.partition.MemberGroupProvider;
import io.atomix.primitive.partition.PartitionManagementService;
import io.atomix.protocols.log.DistributedLogServer;
import io.atomix.protocols.log.partition.LogPartition;
import io.atomix.protocols.log.partition.LogPartitionGroupConfig;
import io.atomix.protocols.log.partition.impl.LogServerCommunicator;
import io.atomix.protocols.log.serializer.impl.LogNamespaces;
import io.atomix.utils.Managed;
import io.atomix.utils.concurrent.ThreadContextFactory;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Serializer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogPartitionServer
implements Managed<LogPartitionServer> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final LogPartition partition;
    private final PartitionManagementService managementService;
    private final LogPartitionGroupConfig config;
    private final ThreadContextFactory threadFactory;
    private DistributedLogServer server;
    private final AtomicBoolean started = new AtomicBoolean();

    public LogPartitionServer(LogPartition partition, PartitionManagementService managementService, LogPartitionGroupConfig config, ThreadContextFactory threadFactory) {
        this.partition = partition;
        this.managementService = managementService;
        this.config = config;
        this.threadFactory = threadFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<LogPartitionServer> start() {
        LogPartitionServer logPartitionServer = this;
        synchronized (logPartitionServer) {
            this.server = this.buildServer();
        }
        return this.server.start().thenApply(s -> {
            this.log.debug("Successfully started server for {}", (Object)this.partition.id());
            this.started.set(true);
            return this;
        });
    }

    public boolean isRunning() {
        return this.started.get();
    }

    private DistributedLogServer buildServer() {
        return DistributedLogServer.builder().withServerName(this.partition.name()).withMembershipService(this.managementService.getMembershipService()).withMemberGroupProvider((MemberGroupProvider)this.config.getMemberGroupProvider()).withProtocol(new LogServerCommunicator(this.partition.name(), Serializer.using((Namespace)LogNamespaces.PROTOCOL), this.managementService.getMessagingService())).withPrimaryElection(this.managementService.getElectionService().getElectionFor(this.partition.id())).withStorageLevel(this.config.getStorageConfig().getLevel()).withDirectory(this.config.getStorageConfig().getDirectory(this.partition.name())).withMaxSegmentSize((int)this.config.getStorageConfig().getSegmentSize().bytes()).withMaxEntrySize((int)this.config.getStorageConfig().getMaxEntrySize().bytes()).withFlushOnCommit(this.config.getStorageConfig().isFlushOnCommit()).withMaxLogSize(this.config.getCompactionConfig().getSize().bytes()).withMaxLogAge(this.config.getCompactionConfig().getAge()).withThreadContextFactory(this.threadFactory).build();
    }

    public CompletableFuture<Void> stop() {
        DistributedLogServer server = this.server;
        if (server != null) {
            return ((CompletableFuture)server.stop().exceptionally(throwable -> {
                this.log.error("Failed stopping server for {}", (Object)this.partition.id(), throwable);
                return null;
            })).thenRun(() -> this.started.set(false));
        }
        this.started.set(false);
        return CompletableFuture.completedFuture(null);
    }
}

