/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.gossip.protocol;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import io.atomix.time.Timestamp;

public class GossipUpdate<K, V> {
    private final K subject;
    private final V value;
    private final Timestamp timestamp;
    private final transient long creationTime = System.currentTimeMillis();

    public GossipUpdate(K subject, V value, Timestamp timestamp) {
        this.subject = subject;
        this.value = value;
        this.timestamp = timestamp;
    }

    public K subject() {
        return this.subject;
    }

    public V value() {
        return this.value;
    }

    public Timestamp timestamp() {
        return this.timestamp;
    }

    public long creationTime() {
        return this.creationTime;
    }

    public boolean isTombstone() {
        return this.value == null;
    }

    public boolean isNewerThan(GossipUpdate<K, V> other) {
        return other == null || this.timestamp.isNewerThan(other.timestamp);
    }

    public boolean isNewerThan(Timestamp timestamp) {
        return this.timestamp.isNewerThan(timestamp);
    }

    public Digest digest() {
        return new Digest(this.timestamp, this.isTombstone());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("subject", this.subject).add("value", this.value).add("timestamp", (Object)this.timestamp).toString();
    }

    public static class Digest {
        private final Timestamp timestamp;
        private final boolean isTombstone;

        public Digest(Timestamp timestamp, boolean isTombstone) {
            this.timestamp = timestamp;
            this.isTombstone = isTombstone;
        }

        public Timestamp timestamp() {
            return this.timestamp;
        }

        public boolean isTombstone() {
            return this.isTombstone;
        }

        public boolean isNewerThan(Digest other) {
            return this.timestamp.isNewerThan(other.timestamp);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.timestamp, this.isTombstone});
        }

        public boolean equals(Object other) {
            if (other instanceof Digest) {
                Digest that = (Digest)other;
                return Objects.equal((Object)this.timestamp, (Object)that.timestamp) && Objects.equal((Object)this.isTombstone, (Object)that.isTombstone);
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("timestamp", (Object)this.timestamp).add("isTombstone", this.isTombstone).toString();
        }
    }
}

