/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging.impl;

import io.atomix.cluster.messaging.impl.AbstractServerConnection;
import io.atomix.cluster.messaging.impl.HandlerRegistry;
import io.atomix.cluster.messaging.impl.LocalClientConnection;
import io.atomix.cluster.messaging.impl.ProtocolReply;
import io.atomix.cluster.messaging.impl.ProtocolRequest;
import java.util.Optional;

final class LocalServerConnection
extends AbstractServerConnection {
    private static final byte[] EMPTY_PAYLOAD = new byte[0];
    private volatile LocalClientConnection clientConnection;

    LocalServerConnection(HandlerRegistry handlers, LocalClientConnection clientConnection) {
        super(handlers);
        this.clientConnection = clientConnection;
    }

    @Override
    public void reply(ProtocolRequest message, ProtocolReply.Status status, Optional<byte[]> payload) {
        LocalClientConnection clientConnection = this.clientConnection;
        if (clientConnection != null) {
            clientConnection.dispatch(new ProtocolReply(message.id(), payload.orElse(EMPTY_PAYLOAD), status));
        }
    }
}

