/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging;

import java.io.File;

public class TlsConfig {
    private static final String CONFIG_DIR = "/conf";
    private static final String KEYSTORE_FILE_NAME = "atomix.jks";
    private static final File DEFAULT_KEYSTORE_FILE = new File("/conf", "atomix.jks");
    private static final String DEFAULT_KEYSTORE_PASSWORD = "changeit";
    private boolean enabled = Boolean.parseBoolean(System.getProperty("io.atomix.enableNettyTLS", Boolean.toString(false)));
    private String keyStore = System.getProperty("javax.net.ssl.keyStore", DEFAULT_KEYSTORE_FILE.toString());
    private String trustStore = System.getProperty("javax.net.ssl.trustStore", DEFAULT_KEYSTORE_FILE.toString());
    private String keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword", "changeit");
    private String trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword", "changeit");

    public boolean isEnabled() {
        return this.enabled;
    }

    public TlsConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public TlsConfig setKeyStore(String keyStore) {
        this.keyStore = keyStore;
        return this;
    }

    public String getTrustStore() {
        return this.trustStore;
    }

    public TlsConfig setTrustStore(String trustStore) {
        this.trustStore = trustStore;
        return this;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public TlsConfig setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
        return this;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public TlsConfig setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
        return this;
    }
}

