/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.impl;

import io.atomix.cluster.Member;
import io.atomix.cluster.MemberId;
import io.atomix.utils.Version;
import io.atomix.utils.net.Address;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;

public class StatefulMember
extends Member {
    private final Version version;
    private final AtomicLong timestamp = new AtomicLong();
    private volatile boolean active;
    private volatile boolean reachable;

    public StatefulMember(MemberId id, Address address) {
        super(id, address);
        this.version = null;
        this.timestamp.set(0L);
    }

    public StatefulMember(MemberId id, Address address, String zone, String rack, String host, Properties properties, Version version) {
        super(id, address, zone, rack, host, properties);
        this.version = version;
        this.timestamp.set(1L);
    }

    @Override
    public Version version() {
        return this.version;
    }

    public long getTimestamp() {
        return this.timestamp.get();
    }

    void setTimestamp(long timestamp) {
        this.timestamp.accumulateAndGet(timestamp, Math::max);
    }

    void incrementTimestamp() {
        this.timestamp.incrementAndGet();
    }

    void setActive(boolean active) {
        this.active = active;
    }

    void setReachable(boolean reachable) {
        this.reachable = reachable;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean isReachable() {
        return this.reachable;
    }
}

