/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.protocol;

import com.google.common.base.Preconditions;
import io.atomix.cluster.protocol.GroupMembershipProtocol;
import io.atomix.cluster.protocol.GroupMembershipProtocolConfig;
import io.atomix.cluster.protocol.HeartbeatMembershipProtocol;
import java.time.Duration;

public class HeartbeatMembershipProtocolConfig
extends GroupMembershipProtocolConfig {
    private static final int DEFAULT_HEARTBEAT_INTERVAL = 1000;
    private static final int DEFAULT_FAILURE_TIMEOUT = 10000;
    private static final int DEFAULT_PHI_FAILURE_THRESHOLD = 10;
    private Duration heartbeatInterval = Duration.ofMillis(1000L);
    private int phiFailureThreshold = 10;
    private Duration failureTimeout = Duration.ofMillis(10000L);

    public GroupMembershipProtocol.Type getType() {
        return HeartbeatMembershipProtocol.TYPE;
    }

    public Duration getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public HeartbeatMembershipProtocolConfig setHeartbeatInterval(Duration heartbeatInterval) {
        this.heartbeatInterval = (Duration)Preconditions.checkNotNull((Object)heartbeatInterval);
        return this;
    }

    public int getPhiFailureThreshold() {
        return this.phiFailureThreshold;
    }

    public HeartbeatMembershipProtocolConfig setPhiFailureThreshold(int phiFailureThreshold) {
        this.phiFailureThreshold = phiFailureThreshold;
        return this;
    }

    public Duration getFailureTimeout() {
        return this.failureTimeout;
    }

    public HeartbeatMembershipProtocolConfig setFailureTimeout(Duration failureTimeout) {
        this.failureTimeout = (Duration)Preconditions.checkNotNull((Object)failureTimeout);
        return this;
    }
}

