/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.protocol;

import com.google.common.base.Preconditions;
import io.atomix.cluster.protocol.GroupMembershipProtocol;
import io.atomix.cluster.protocol.GroupMembershipProtocolConfig;
import io.atomix.cluster.protocol.PhiMembershipProtocol;
import java.time.Duration;

public class PhiMembershipProtocolConfig
extends GroupMembershipProtocolConfig {
    private static final int DEFAULT_HEARTBEAT_INTERVAL = 1000;
    private static final int DEFAULT_FAILURE_TIMEOUT = 10000;
    private static final int DEFAULT_PHI_FAILURE_THRESHOLD = 10;
    private Duration heartbeatInterval = Duration.ofMillis(1000L);
    private int failureThreshold = 10;
    private Duration failureTimeout = Duration.ofMillis(10000L);

    public GroupMembershipProtocol.Type getType() {
        return PhiMembershipProtocol.TYPE;
    }

    public Duration getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public PhiMembershipProtocolConfig setHeartbeatInterval(Duration heartbeatInterval) {
        this.heartbeatInterval = (Duration)Preconditions.checkNotNull((Object)heartbeatInterval);
        return this;
    }

    public int getFailureThreshold() {
        return this.failureThreshold;
    }

    public PhiMembershipProtocolConfig setFailureThreshold(int failureThreshold) {
        this.failureThreshold = failureThreshold;
        return this;
    }

    public Duration getFailureTimeout() {
        return this.failureTimeout;
    }

    public PhiMembershipProtocolConfig setFailureTimeout(Duration failureTimeout) {
        this.failureTimeout = (Duration)Preconditions.checkNotNull((Object)failureTimeout);
        return this;
    }
}

