/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging.impl;

public abstract class InternalMessage {
    private final int preamble;
    private final long id;
    private final byte[] payload;

    protected InternalMessage(int preamble, long id, byte[] payload) {
        this.preamble = preamble;
        this.id = id;
        this.payload = payload;
    }

    public abstract Type type();

    public boolean isRequest() {
        return this.type() == Type.REQUEST;
    }

    public boolean isReply() {
        return this.type() == Type.REPLY;
    }

    public int preamble() {
        return this.preamble;
    }

    public long id() {
        return this.id;
    }

    public byte[] payload() {
        return this.payload;
    }

    public static enum Type {
        REQUEST(1),
        REPLY(2);

        private final int id;

        private Type(int id) {
            this.id = id;
        }

        public int id() {
            return this.id;
        }

        public static Type forId(int id) {
            switch (id) {
                case 1: {
                    return REQUEST;
                }
                case 2: {
                    return REPLY;
                }
            }
            throw new IllegalArgumentException("Unknown status ID " + id);
        }
    }
}

