/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.discovery;

import com.esotericsoftware.kryo.Serializer;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.atomix.cluster.BootstrapService;
import io.atomix.cluster.Node;
import io.atomix.cluster.NodeConfig;
import io.atomix.cluster.NodeId;
import io.atomix.cluster.discovery.BootstrapDiscoveryBuilder;
import io.atomix.cluster.discovery.BootstrapDiscoveryConfig;
import io.atomix.cluster.discovery.NodeDiscoveryEvent;
import io.atomix.cluster.discovery.NodeDiscoveryEventListener;
import io.atomix.cluster.discovery.NodeDiscoveryProvider;
import io.atomix.cluster.impl.AddressSerializer;
import io.atomix.cluster.impl.PhiAccrualFailureDetector;
import io.atomix.utils.concurrent.ComposableFuture;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.concurrent.Threads;
import io.atomix.utils.event.AbstractListenerManager;
import io.atomix.utils.event.Event;
import io.atomix.utils.net.Address;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Namespaces;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapDiscoveryProvider
extends AbstractListenerManager<NodeDiscoveryEvent, NodeDiscoveryEventListener>
implements NodeDiscoveryProvider {
    public static final Type TYPE = new Type();
    private static final Logger LOGGER = LoggerFactory.getLogger(BootstrapDiscoveryProvider.class);
    private static final io.atomix.utils.serializer.Serializer SERIALIZER = io.atomix.utils.serializer.Serializer.using((Namespace)Namespace.builder().register(Namespaces.BASIC).nextId(500).register(new Class[]{Node.class}).register(new Class[]{NodeId.class}).register((Serializer)new AddressSerializer(), new Class[]{Address.class}).build());
    private static final String HEARTBEAT_MESSAGE = "atomix-cluster-heartbeat";
    private final Collection<Node> bootstrapNodes;
    private final BootstrapDiscoveryConfig config;
    private volatile BootstrapService bootstrap;
    private Map<Address, Node> nodes = Maps.newConcurrentMap();
    private final ScheduledExecutorService heartbeatScheduler = Executors.newSingleThreadScheduledExecutor(Threads.namedThreads((String)"atomix-bootstrap-heartbeat-sender", (Logger)LOGGER));
    private final ExecutorService heartbeatExecutor = Executors.newSingleThreadExecutor(Threads.namedThreads((String)"atomix-bootstrap-heartbeat-receiver", (Logger)LOGGER));
    private ScheduledFuture<?> heartbeatFuture;
    private final Map<Address, PhiAccrualFailureDetector> failureDetectors = Maps.newConcurrentMap();

    public static BootstrapDiscoveryBuilder builder() {
        return new BootstrapDiscoveryBuilder();
    }

    public BootstrapDiscoveryProvider(Node ... bootstrapNodes) {
        this(Arrays.asList(bootstrapNodes));
    }

    public BootstrapDiscoveryProvider(Collection<Node> bootstrapNodes) {
        this(new BootstrapDiscoveryConfig().setNodes(bootstrapNodes.stream().map(node -> new NodeConfig().setId(node.id()).setAddress(node.address())).collect(Collectors.toList())));
    }

    BootstrapDiscoveryProvider(BootstrapDiscoveryConfig config) {
        this.config = (BootstrapDiscoveryConfig)Preconditions.checkNotNull((Object)config);
        this.bootstrapNodes = ImmutableSet.copyOf((Collection)config.getNodes().stream().map(Node::new).collect(Collectors.toList()));
    }

    public BootstrapDiscoveryConfig config() {
        return this.config;
    }

    @Override
    public Set<Node> getNodes() {
        return ImmutableSet.copyOf(this.nodes.values());
    }

    private CompletableFuture<Void> sendHeartbeats(Node localNode) {
        Stream<Address> clusterLocations = this.nodes.values().stream().filter(node -> !node.address().equals((Object)localNode.address())).map(node -> node.address());
        Stream<Address> bootstrapLocations = this.bootstrapNodes.stream().filter(node -> !node.address().equals((Object)localNode.address()) && !this.nodes.containsKey(node.address())).map(node -> node.address());
        return Futures.allOf(Stream.concat(clusterLocations, bootstrapLocations).map(address -> {
            LOGGER.trace("{} - Sending heartbeat: {}", (Object)localNode.address(), address);
            return this.sendHeartbeat(localNode, (Address)address).exceptionally(v -> null);
        }).collect(Collectors.toList())).thenApply(v -> null);
    }

    private CompletableFuture<Void> sendHeartbeat(Node localNode, Address address) {
        return ((CompletableFuture)((CompletableFuture)this.bootstrap.getMessagingService().sendAndReceive(address, HEARTBEAT_MESSAGE, SERIALIZER.encode((Object)localNode)).whenCompleteAsync((response, error) -> {
            if (error == null) {
                Collection nodes = (Collection)SERIALIZER.decode(response);
                for (Node node : nodes) {
                    if (node.address().equals((Object)address)) {
                        Node oldNode = this.nodes.put(node.address(), node);
                        if (oldNode != null && !oldNode.id().equals(node.id())) {
                            this.failureDetectors.remove(oldNode.address());
                            this.post((Event)new NodeDiscoveryEvent(NodeDiscoveryEvent.Type.LEAVE, oldNode));
                            this.post((Event)new NodeDiscoveryEvent(NodeDiscoveryEvent.Type.JOIN, node));
                            continue;
                        }
                        if (oldNode != null) continue;
                        this.post((Event)new NodeDiscoveryEvent(NodeDiscoveryEvent.Type.JOIN, node));
                        continue;
                    }
                    if (this.nodes.containsKey(node.address()) && this.nodes.get(node.address()).id().equals(node.id())) continue;
                    this.sendHeartbeat(localNode, node.address());
                }
            } else {
                Node node;
                LOGGER.debug("{} - Sending heartbeat to {} failed", new Object[]{localNode, address, error});
                PhiAccrualFailureDetector failureDetector = this.failureDetectors.computeIfAbsent(address, n -> new PhiAccrualFailureDetector());
                double phi = failureDetector.phi();
                if ((phi >= (double)this.config.getFailureThreshold() || phi == 0.0 && System.currentTimeMillis() - failureDetector.lastUpdated() > this.config.getFailureTimeout().toMillis()) && (node = this.nodes.remove(address)) != null) {
                    this.failureDetectors.remove(node.address());
                    this.post((Event)new NodeDiscoveryEvent(NodeDiscoveryEvent.Type.LEAVE, node));
                }
            }
        }, (Executor)this.heartbeatExecutor)).exceptionally(e -> null)).thenApply(v -> null);
    }

    private byte[] handleHeartbeat(Node localNode, Node node) {
        LOGGER.trace("{} - Received heartbeat: {}", (Object)localNode.address(), (Object)localNode.address());
        this.failureDetectors.computeIfAbsent(localNode.address(), n -> new PhiAccrualFailureDetector()).report();
        Node oldNode = this.nodes.put(node.address(), node);
        if (oldNode != null && !oldNode.id().equals(node.id())) {
            this.failureDetectors.remove(oldNode.address());
            this.post((Event)new NodeDiscoveryEvent(NodeDiscoveryEvent.Type.LEAVE, oldNode));
            this.post((Event)new NodeDiscoveryEvent(NodeDiscoveryEvent.Type.JOIN, node));
        } else if (oldNode == null) {
            this.post((Event)new NodeDiscoveryEvent(NodeDiscoveryEvent.Type.JOIN, node));
        }
        return SERIALIZER.encode((Object)Lists.newArrayList(this.nodes.values()));
    }

    @Override
    public CompletableFuture<Void> join(BootstrapService bootstrap, Node localNode) {
        if (this.nodes.putIfAbsent(localNode.address(), localNode) == null) {
            this.bootstrap = bootstrap;
            this.post((Event)new NodeDiscoveryEvent(NodeDiscoveryEvent.Type.JOIN, localNode));
            bootstrap.getMessagingService().registerHandler(HEARTBEAT_MESSAGE, (a, p) -> this.handleHeartbeat(localNode, (Node)SERIALIZER.decode(p)), (Executor)this.heartbeatExecutor);
            ComposableFuture future = new ComposableFuture();
            this.sendHeartbeats(localNode).whenComplete((r, e) -> future.complete(null));
            this.heartbeatFuture = this.heartbeatScheduler.scheduleAtFixedRate(() -> this.sendHeartbeats(localNode), 0L, this.config.getHeartbeatInterval().toMillis(), TimeUnit.MILLISECONDS);
            return future.thenRun(() -> LOGGER.info("Joined"));
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> leave(Node localNode) {
        if (this.nodes.remove(localNode.address()) != null) {
            this.post((Event)new NodeDiscoveryEvent(NodeDiscoveryEvent.Type.LEAVE, localNode));
            this.bootstrap.getMessagingService().unregisterHandler(HEARTBEAT_MESSAGE);
            ScheduledFuture<?> heartbeatFuture = this.heartbeatFuture;
            if (heartbeatFuture != null) {
                heartbeatFuture.cancel(false);
            }
            this.heartbeatScheduler.shutdownNow();
            this.heartbeatExecutor.shutdownNow();
            LOGGER.info("Left");
        }
        return CompletableFuture.completedFuture(null);
    }

    public static class Type
    implements NodeDiscoveryProvider.Type<BootstrapDiscoveryConfig> {
        private static final String NAME = "bootstrap";

        public String name() {
            return NAME;
        }

        public BootstrapDiscoveryConfig newConfig() {
            return new BootstrapDiscoveryConfig();
        }

        @Override
        public NodeDiscoveryProvider newProvider(BootstrapDiscoveryConfig config) {
            return new BootstrapDiscoveryProvider(config);
        }
    }
}

