/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.impl;

import com.esotericsoftware.kryo.Serializer;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.atomix.cluster.BootstrapService;
import io.atomix.cluster.ClusterMembershipEvent;
import io.atomix.cluster.ClusterMembershipEventListener;
import io.atomix.cluster.ClusterMembershipService;
import io.atomix.cluster.ManagedClusterMembershipService;
import io.atomix.cluster.Member;
import io.atomix.cluster.MemberId;
import io.atomix.cluster.MembershipConfig;
import io.atomix.cluster.Node;
import io.atomix.cluster.discovery.ManagedNodeDiscoveryService;
import io.atomix.cluster.discovery.NodeDiscoveryEvent;
import io.atomix.cluster.discovery.NodeDiscoveryEventListener;
import io.atomix.cluster.impl.AddressSerializer;
import io.atomix.cluster.impl.PhiAccrualFailureDetector;
import io.atomix.cluster.impl.StatefulMember;
import io.atomix.utils.Version;
import io.atomix.utils.concurrent.Threads;
import io.atomix.utils.event.AbstractListenerManager;
import io.atomix.utils.event.Event;
import io.atomix.utils.net.Address;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Namespaces;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClusterMembershipService
extends AbstractListenerManager<ClusterMembershipEvent, ClusterMembershipEventListener>
implements ManagedClusterMembershipService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultClusterMembershipService.class);
    private static final String METADATA_BROADCAST = "atomix-cluster-metadata";
    private static final io.atomix.utils.serializer.Serializer SERIALIZER = io.atomix.utils.serializer.Serializer.using((Namespace)Namespace.builder().register(Namespaces.BASIC).nextId(500).register(new Class[]{MemberId.class}).register(new Class[]{StatefulMember.class}).register((Serializer)new AddressSerializer(), new Class[]{Address.class}).build("ClusterMembershipService"));
    private final MembershipConfig config;
    private final ManagedNodeDiscoveryService discoveryService;
    private final BootstrapService bootstrapService;
    private final AtomicBoolean started = new AtomicBoolean();
    private final StatefulMember localMember;
    private volatile Properties localProperties = new Properties();
    private final Map<MemberId, StatefulMember> members = Maps.newConcurrentMap();
    private final Map<MemberId, PhiAccrualFailureDetector> failureDetectors = Maps.newConcurrentMap();
    private final NodeDiscoveryEventListener discoveryEventListener = this::handleDiscoveryEvent;
    private final ScheduledExecutorService heartbeatScheduler = Executors.newSingleThreadScheduledExecutor(Threads.namedThreads((String)"atomix-cluster-heartbeat-sender", (Logger)LOGGER));
    private final ExecutorService eventExecutor = Executors.newSingleThreadExecutor(Threads.namedThreads((String)"atomix-cluster-events", (Logger)LOGGER));
    private ScheduledFuture<?> heartbeatFuture;

    public DefaultClusterMembershipService(Member localMember, Version version, ManagedNodeDiscoveryService discoveryService, BootstrapService bootstrapService, MembershipConfig config) {
        this.discoveryService = (ManagedNodeDiscoveryService)Preconditions.checkNotNull((Object)discoveryService, (Object)"discoveryService cannot be null");
        this.bootstrapService = (BootstrapService)Preconditions.checkNotNull((Object)bootstrapService, (Object)"bootstrapService cannot be null");
        this.config = (MembershipConfig)Preconditions.checkNotNull((Object)config);
        this.localMember = new StatefulMember(localMember.id(), localMember.address(), localMember.zone(), localMember.rack(), localMember.host(), localMember.properties(), version);
    }

    @Override
    public Member getLocalMember() {
        return this.localMember;
    }

    @Override
    public Set<Member> getMembers() {
        return ImmutableSet.copyOf(this.members.values());
    }

    @Override
    public Member getMember(MemberId memberId) {
        return this.members.get(memberId);
    }

    protected void post(ClusterMembershipEvent event) {
        this.eventExecutor.execute(() -> super.post((Event)event));
    }

    private void handleDiscoveryEvent(NodeDiscoveryEvent event) {
        switch ((NodeDiscoveryEvent.Type)event.type()) {
            case JOIN: {
                this.handleJoinEvent((Node)event.subject());
                break;
            }
            case LEAVE: {
                this.handleLeaveEvent((Node)event.subject());
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private void handleJoinEvent(Node node) {
        StatefulMember member = new StatefulMember(MemberId.from((String)((Object)node.id().id())), node.address());
        member.setActive(true);
        member.setReachable(true);
        if (this.members.putIfAbsent(member.id(), member) == null) {
            this.post(new ClusterMembershipEvent(ClusterMembershipEvent.Type.MEMBER_ADDED, member));
        }
    }

    private void handleLeaveEvent(Node node) {
        StatefulMember member = this.members.remove(MemberId.from((String)((Object)node.id().id())));
        if (member != null) {
            this.post(new ClusterMembershipEvent(ClusterMembershipEvent.Type.MEMBER_REMOVED, member));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkMetadata() {
        Member localMember = this.getLocalMember();
        if (!localMember.properties().equals(this.localProperties)) {
            DefaultClusterMembershipService defaultClusterMembershipService = this;
            synchronized (defaultClusterMembershipService) {
                if (!localMember.properties().equals(this.localProperties)) {
                    this.localProperties = localMember.properties();
                    this.post(new ClusterMembershipEvent(ClusterMembershipEvent.Type.METADATA_CHANGED, localMember));
                    this.broadcastMetadata();
                }
            }
        }
    }

    private void broadcastMetadata() {
        this.checkMetadata();
        this.members.values().stream().filter(member -> !member.id().equals(this.localMember.id())).forEach(this::broadcastMetadata);
        this.detectFailures();
    }

    private void broadcastMetadata(StatefulMember member) {
        LOGGER.trace("{} - Sending heartbeat to {}", (Object)this.localMember.id(), (Object)member);
        this.bootstrapService.getMessagingService().sendAsync(member.address(), METADATA_BROADCAST, SERIALIZER.encode((Object)this.localMember)).whenComplete((result, error) -> {
            if (error != null) {
                LOGGER.debug("{} - Failed to send heartbeat to {}", new Object[]{this.localMember.id(), member, error});
            } else {
                LOGGER.trace("{} - Successfully sent heartbeat to {}", (Object)this.localMember.id(), (Object)member);
            }
        });
    }

    private void handleMetadata(Address address, byte[] message) {
        StatefulMember remoteMember = (StatefulMember)SERIALIZER.decode(message);
        LOGGER.trace("{} - Received heartbeat from {}", (Object)this.localMember.id(), (Object)remoteMember);
        StatefulMember localMember = this.members.get(remoteMember.id());
        if (localMember != null) {
            if (!localMember.isReachable()) {
                LOGGER.info("{} - Member reachable: {}", (Object)localMember.id(), (Object)localMember);
                localMember.setReachable(true);
                this.post(new ClusterMembershipEvent(ClusterMembershipEvent.Type.REACHABILITY_CHANGED, localMember));
            }
            if (!Objects.equals(localMember.version(), remoteMember.version()) | !localMember.properties().equals(remoteMember.properties())) {
                LOGGER.info("{} - Member updated: {}", (Object)remoteMember.id(), (Object)remoteMember);
                this.members.put(remoteMember.id(), remoteMember);
                this.post(new ClusterMembershipEvent(ClusterMembershipEvent.Type.METADATA_CHANGED, remoteMember));
            }
            this.failureDetectors.computeIfAbsent(localMember.id(), id -> new PhiAccrualFailureDetector()).report();
        }
    }

    private void detectFailures() {
        this.members.values().stream().filter(member -> !member.id().equals(this.localMember.id())).forEach(this::detectFailure);
    }

    private void detectFailure(StatefulMember member) {
        PhiAccrualFailureDetector failureDetector = this.failureDetectors.computeIfAbsent(member.id(), n -> new PhiAccrualFailureDetector());
        double phi = failureDetector.phi();
        if ((phi >= (double)this.config.getReachabilityThreshold() || phi == 0.0 && System.currentTimeMillis() - failureDetector.lastUpdated() > this.config.getReachabilityTimeout().toMillis()) && member.isReachable()) {
            LOGGER.info("{} - Member unreachable: {}", (Object)this.localMember.id(), (Object)member);
            member.setReachable(false);
            this.post(new ClusterMembershipEvent(ClusterMembershipEvent.Type.REACHABILITY_CHANGED, member));
        }
    }

    public CompletableFuture<ClusterMembershipService> start() {
        if (this.started.compareAndSet(false, true)) {
            this.discoveryService.addListener(this.discoveryEventListener);
            return ((CompletableFuture)this.discoveryService.start().thenRun(() -> {
                LOGGER.info("{} - Member activated: {}", (Object)this.localMember.id(), (Object)this.localMember);
                this.localMember.setActive(true);
                this.localMember.setReachable(true);
                this.members.put(this.localMember.id(), this.localMember);
                this.bootstrapService.getMessagingService().registerHandler(METADATA_BROADCAST, this::handleMetadata, (Executor)this.heartbeatScheduler);
                this.heartbeatFuture = this.heartbeatScheduler.scheduleAtFixedRate(this::broadcastMetadata, 0L, this.config.getBroadcastInterval().toMillis(), TimeUnit.MILLISECONDS);
            })).thenApply(v -> {
                LOGGER.info("Started");
                return this;
            });
        }
        return CompletableFuture.completedFuture(null);
    }

    public boolean isRunning() {
        return this.started.get();
    }

    public CompletableFuture<Void> stop() {
        if (this.started.compareAndSet(true, false)) {
            return this.discoveryService.stop().thenRun(() -> {
                this.discoveryService.removeListener(this.discoveryEventListener);
                this.heartbeatFuture.cancel(true);
                this.heartbeatScheduler.shutdownNow();
                this.eventExecutor.shutdownNow();
                LOGGER.info("{} - Member deactivated: {}", (Object)this.localMember.id(), (Object)this.localMember);
                this.localMember.setActive(false);
                this.localMember.setReachable(false);
                this.members.clear();
                this.bootstrapService.getMessagingService().unregisterHandler(METADATA_BROADCAST);
                LOGGER.info("Stopped");
            });
        }
        return CompletableFuture.completedFuture(null);
    }
}

