/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Streams;
import io.atomix.cluster.AtomixClusterBuilder;
import io.atomix.cluster.BootstrapService;
import io.atomix.cluster.ClusterConfig;
import io.atomix.cluster.ClusterMembershipService;
import io.atomix.cluster.ManagedClusterMembershipService;
import io.atomix.cluster.Member;
import io.atomix.cluster.discovery.BootstrapDiscoveryProvider;
import io.atomix.cluster.discovery.MulticastDiscoveryConfig;
import io.atomix.cluster.discovery.MulticastDiscoveryProvider;
import io.atomix.cluster.discovery.NodeDiscoveryConfig;
import io.atomix.cluster.discovery.NodeDiscoveryProvider;
import io.atomix.cluster.impl.DefaultClusterMembershipService;
import io.atomix.cluster.impl.DefaultNodeDiscoveryService;
import io.atomix.cluster.messaging.BroadcastService;
import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.atomix.cluster.messaging.ClusterEventService;
import io.atomix.cluster.messaging.ManagedBroadcastService;
import io.atomix.cluster.messaging.ManagedClusterCommunicationService;
import io.atomix.cluster.messaging.ManagedClusterEventService;
import io.atomix.cluster.messaging.ManagedMessagingService;
import io.atomix.cluster.messaging.MessagingService;
import io.atomix.cluster.messaging.impl.DefaultClusterCommunicationService;
import io.atomix.cluster.messaging.impl.DefaultClusterEventService;
import io.atomix.cluster.messaging.impl.NettyBroadcastService;
import io.atomix.cluster.messaging.impl.NettyMessagingService;
import io.atomix.utils.Managed;
import io.atomix.utils.Version;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.concurrent.SingleThreadContext;
import io.atomix.utils.concurrent.ThreadContext;
import io.atomix.utils.config.ConfigMapper;
import io.atomix.utils.net.Address;
import java.io.File;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomixCluster
implements BootstrapService,
Managed<Void> {
    private static final String[] DEFAULT_RESOURCES = new String[]{"cluster"};
    private static final Logger LOGGER = LoggerFactory.getLogger(AtomixCluster.class);
    private static final Version VERSION = Version.from((int)3, (int)0, (int)0, null);
    protected final ManagedMessagingService messagingService;
    protected final ManagedBroadcastService broadcastService;
    protected final NodeDiscoveryProvider discoveryProvider;
    protected final ManagedClusterMembershipService membershipService;
    protected final ManagedClusterCommunicationService communicationService;
    protected final ManagedClusterEventService eventService;
    protected volatile CompletableFuture<Void> openFuture;
    protected volatile CompletableFuture<Void> closeFuture;
    private final ThreadContext threadContext = new SingleThreadContext("atomix-cluster-%d");
    private final AtomicBoolean started = new AtomicBoolean();

    private static String[] withDefaultResources(String config) {
        return (String[])Streams.concat((Stream[])new Stream[]{Stream.of(config), Stream.of(DEFAULT_RESOURCES)}).toArray(String[]::new);
    }

    private static ClusterConfig config(String[] resources, ClassLoader classLoader) {
        return (ClusterConfig)new ConfigMapper(classLoader).loadResources(ClusterConfig.class, resources);
    }

    public static AtomixClusterBuilder builder() {
        return AtomixCluster.builder(Thread.currentThread().getContextClassLoader());
    }

    public static AtomixClusterBuilder builder(ClassLoader classLoader) {
        return AtomixCluster.builder(AtomixCluster.config(DEFAULT_RESOURCES, classLoader));
    }

    public static AtomixClusterBuilder builder(String config) {
        return AtomixCluster.builder(config, Thread.currentThread().getContextClassLoader());
    }

    public static AtomixClusterBuilder builder(String config, ClassLoader classLoader) {
        return new AtomixClusterBuilder(AtomixCluster.config(AtomixCluster.withDefaultResources(config), classLoader));
    }

    public static AtomixClusterBuilder builder(ClusterConfig config) {
        return new AtomixClusterBuilder(config);
    }

    public AtomixCluster(String configFile) {
        this(AtomixCluster.loadConfig(new File(System.getProperty("atomix.root", System.getProperty("user.dir")), configFile), Thread.currentThread().getContextClassLoader()));
    }

    public AtomixCluster(File configFile) {
        this(AtomixCluster.loadConfig(configFile, Thread.currentThread().getContextClassLoader()));
    }

    public AtomixCluster(ClusterConfig config) {
        this.messagingService = AtomixCluster.buildMessagingService(config);
        this.broadcastService = AtomixCluster.buildBroadcastService(config);
        this.discoveryProvider = AtomixCluster.buildLocationProvider(config);
        this.membershipService = AtomixCluster.buildClusterMembershipService(config, this, this.discoveryProvider);
        this.communicationService = AtomixCluster.buildClusterMessagingService(this.membershipService, this.messagingService);
        this.eventService = AtomixCluster.buildClusterEventService(this.membershipService, this.messagingService);
    }

    @Override
    public BroadcastService getBroadcastService() {
        return this.broadcastService;
    }

    @Override
    public MessagingService getMessagingService() {
        return this.messagingService;
    }

    public ClusterMembershipService getMembershipService() {
        return this.membershipService;
    }

    public ClusterCommunicationService getCommunicationService() {
        return this.communicationService;
    }

    public ClusterEventService getEventService() {
        return this.eventService;
    }

    public synchronized CompletableFuture<Void> start() {
        if (this.closeFuture != null) {
            return Futures.exceptionalFuture((Throwable)new IllegalStateException("AtomixCluster instance " + (this.closeFuture.isDone() ? "shutdown" : "shutting down")));
        }
        if (this.openFuture != null) {
            return this.openFuture;
        }
        this.openFuture = this.startServices().thenComposeAsync(v -> this.completeStartup(), (Executor)this.threadContext);
        return this.openFuture;
    }

    protected CompletableFuture<Void> startServices() {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.messagingService.start().thenComposeAsync(v -> this.broadcastService.start(), (Executor)this.threadContext)).thenComposeAsync(v -> this.membershipService.start(), (Executor)this.threadContext)).thenComposeAsync(v -> this.communicationService.start(), (Executor)this.threadContext)).thenComposeAsync(v -> this.eventService.start(), (Executor)this.threadContext)).thenApply(v -> null);
    }

    protected CompletableFuture<Void> completeStartup() {
        this.started.set(true);
        LOGGER.info("Started");
        return CompletableFuture.completedFuture(null);
    }

    public boolean isRunning() {
        return this.started.get();
    }

    public synchronized CompletableFuture<Void> stop() {
        if (this.closeFuture != null) {
            return this.closeFuture;
        }
        this.closeFuture = this.stopServices().thenComposeAsync(v -> this.completeShutdown(), (Executor)this.threadContext);
        return this.closeFuture;
    }

    protected CompletableFuture<Void> stopServices() {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.communicationService.stop().exceptionally(e -> null)).thenComposeAsync(v -> this.eventService.stop(), (Executor)this.threadContext)).exceptionally(e -> null)).thenComposeAsync(v -> this.membershipService.stop(), (Executor)this.threadContext)).exceptionally(e -> null)).thenComposeAsync(v -> this.broadcastService.stop(), (Executor)this.threadContext)).exceptionally(e -> null)).thenComposeAsync(v -> this.messagingService.stop(), (Executor)this.threadContext)).exceptionally(e -> null);
    }

    protected CompletableFuture<Void> completeShutdown() {
        this.threadContext.close();
        this.started.set(false);
        LOGGER.info("Stopped");
        return CompletableFuture.completedFuture(null);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).toString();
    }

    private static ClusterConfig loadConfig(File config, ClassLoader classLoader) {
        return (ClusterConfig)new ConfigMapper(classLoader).loadResources(ClusterConfig.class, new String[]{config.getAbsolutePath()});
    }

    protected static ManagedMessagingService buildMessagingService(ClusterConfig config) {
        return NettyMessagingService.builder().withName(config.getClusterId()).withAddress(config.getNodeConfig().getAddress()).build();
    }

    protected static ManagedBroadcastService buildBroadcastService(ClusterConfig config) {
        return NettyBroadcastService.builder().withLocalAddress(config.getNodeConfig().getAddress()).withGroupAddress(new Address(config.getMulticastConfig().getGroup().getHostAddress(), config.getMulticastConfig().getPort(), config.getMulticastConfig().getGroup())).withEnabled(config.getMulticastConfig().isEnabled()).build();
    }

    protected static NodeDiscoveryProvider buildLocationProvider(ClusterConfig config) {
        NodeDiscoveryConfig discoveryProviderConfig = config.getDiscoveryConfig();
        if (discoveryProviderConfig != null) {
            return ((NodeDiscoveryProvider.Type)discoveryProviderConfig.getType()).newProvider(discoveryProviderConfig);
        }
        if (config.getMulticastConfig().isEnabled()) {
            return new MulticastDiscoveryProvider(new MulticastDiscoveryConfig());
        }
        return new BootstrapDiscoveryProvider(Collections.emptyList());
    }

    protected static ManagedClusterMembershipService buildClusterMembershipService(ClusterConfig config, BootstrapService bootstrapService, NodeDiscoveryProvider discoveryProvider) {
        Member localMember = Member.builder().withId(config.getNodeConfig().getId()).withAddress(config.getNodeConfig().getAddress()).withHost(config.getNodeConfig().getHost()).withRack(config.getNodeConfig().getRack()).withZone(config.getNodeConfig().getZone()).withProperties(config.getNodeConfig().getProperties()).build();
        return new DefaultClusterMembershipService(localMember, VERSION, new DefaultNodeDiscoveryService(bootstrapService, localMember, discoveryProvider), bootstrapService, config.getMembershipConfig());
    }

    protected static ManagedClusterCommunicationService buildClusterMessagingService(ClusterMembershipService membershipService, MessagingService messagingService) {
        return new DefaultClusterCommunicationService(membershipService, messagingService);
    }

    protected static ManagedClusterEventService buildClusterEventService(ClusterMembershipService membershipService, MessagingService messagingService) {
        return new DefaultClusterEventService(membershipService, messagingService);
    }
}

