/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.impl;

import com.google.common.base.Preconditions;
import io.atomix.cluster.Node;
import io.atomix.cluster.NodeId;
import io.atomix.messaging.Endpoint;
import io.atomix.utils.time.LogicalTimestamp;
import io.atomix.utils.time.Timestamp;

public class ReplicatedNode
extends Node {
    private final LogicalTimestamp timestamp;
    private final boolean tombstone;

    public ReplicatedNode(NodeId id, Node.Type type, Endpoint endpoint, LogicalTimestamp timestamp, boolean tombstone) {
        super(id, type, endpoint);
        this.timestamp = (LogicalTimestamp)Preconditions.checkNotNull((Object)timestamp, (Object)"timestamp cannot be null");
        this.tombstone = tombstone;
    }

    public LogicalTimestamp timestamp() {
        return this.timestamp;
    }

    public boolean tombstone() {
        return this.tombstone;
    }

    public boolean isNewerThan(Timestamp timestamp) {
        return this.timestamp().isNewerThan(timestamp);
    }

    public boolean isOlderThan(Timestamp timestamp) {
        return this.timestamp().isOlderThan(timestamp);
    }
}

