/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging.impl;

import com.google.common.base.MoreObjects;
import io.atomix.cluster.NodeId;
import io.atomix.utils.ArraySizeHashPrinter;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;

public class ClusterMessage {
    private final NodeId sender;
    private final String subject;
    private final byte[] payload;
    private transient byte[] response;

    public ClusterMessage(NodeId sender, String subject, byte[] payload) {
        this.sender = sender;
        this.subject = subject;
        this.payload = payload;
    }

    public NodeId sender() {
        return this.sender;
    }

    public String subject() {
        return this.subject;
    }

    public byte[] payload() {
        return this.payload;
    }

    public void respond(byte[] data) {
        this.response = data;
    }

    public byte[] response() {
        return this.response;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("sender", (Object)this.sender).add("subject", (Object)this.subject).add("payload", (Object)ArraySizeHashPrinter.of((byte[])this.payload)).toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ClusterMessage)) {
            return false;
        }
        ClusterMessage that = (ClusterMessage)o;
        return Objects.equals(this.sender, that.sender) && Objects.equals(this.subject, that.subject) && Arrays.equals(this.payload, that.payload);
    }

    public byte[] getBytes() {
        byte[] senderBytes = this.sender.toString().getBytes(StandardCharsets.UTF_8);
        byte[] subjectBytes = this.subject.getBytes(StandardCharsets.UTF_8);
        int capacity = 12 + senderBytes.length + subjectBytes.length + this.payload.length;
        ByteBuffer buffer = ByteBuffer.allocate(capacity);
        buffer.putInt(senderBytes.length);
        buffer.put(senderBytes);
        buffer.putInt(subjectBytes.length);
        buffer.put(subjectBytes);
        buffer.putInt(this.payload.length);
        buffer.put(this.payload);
        return buffer.array();
    }

    public static ClusterMessage fromBytes(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        byte[] senderBytes = new byte[buffer.getInt()];
        buffer.get(senderBytes);
        byte[] subjectBytes = new byte[buffer.getInt()];
        buffer.get(subjectBytes);
        byte[] payloadBytes = new byte[buffer.getInt()];
        buffer.get(payloadBytes);
        return new ClusterMessage(new NodeId(new String(senderBytes, StandardCharsets.UTF_8)), new String(subjectBytes, StandardCharsets.UTF_8), payloadBytes);
    }

    public int hashCode() {
        return Objects.hash(this.sender, this.subject, this.payload);
    }
}

