/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.util;

import io.atleon.util.TypeResolution;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public final class Instantiation {
    private Instantiation() {
    }

    public static <T> T oneTyped(Class<? extends T> typeOrSubType, String qualifiedNameOfSubType, Object ... parameters) {
        return Instantiation.oneTyped(typeOrSubType, TypeResolution.classForQualifiedName(qualifiedNameOfSubType), parameters);
    }

    public static <T> T oneTyped(Class<? extends T> typeOrSubType, Class<?> subType, Object ... parameters) {
        if (typeOrSubType.isAssignableFrom(subType)) {
            return typeOrSubType.cast(Instantiation.one(subType, parameters));
        }
        throw new IllegalArgumentException("Cannot instantiate type=" + typeOrSubType + " using subType=" + subType);
    }

    public static <T> T one(Class<? extends T> clazz, Object ... parameters) {
        try {
            Class[] parameterTypes = (Class[])Arrays.stream(parameters).map(Instantiation::deduceParameterClass).toArray(Class[]::new);
            Constructor<T> constructor = clazz.getDeclaredConstructor(parameterTypes);
            Instantiation.ensureConstructorAccessibility(constructor);
            return constructor.newInstance(parameters);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not instantiate instance of Class: " + clazz, e);
        }
    }

    private static Class<?> deduceParameterClass(Object parameter) {
        if (parameter instanceof Collection) {
            return Collection.class;
        }
        return parameter instanceof Map ? Map.class : parameter.getClass();
    }

    private static void ensureConstructorAccessibility(Constructor<?> constructor) {
        if (!Modifier.isPublic(constructor.getModifiers()) && !constructor.isAccessible()) {
            constructor.setAccessible(true);
        }
    }
}

