/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.util;

import io.atleon.util.Calculation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class Collecting {
    private Collecting() {
    }

    public static <T, C extends Collection<T>> List<C> binaryStrides(Collection<T> collection, Supplier<C> collectionSupplier) {
        if (collection.size() <= 1) {
            Collection result = (Collection)collectionSupplier.get();
            result.addAll(collection);
            return Collections.singletonList(result);
        }
        ArrayList list = new ArrayList(collection);
        return IntStream.range(0, Collecting.totalBinaryStrides(list.size())).mapToObj(it -> Collecting.binaryStride(list, it, collectionSupplier)).collect(Collectors.toList());
    }

    public static <T, V extends Comparable<? super V>, C extends Collection<T>> C greatest(Collection<T> collection, Function<? super T, ? extends V> evaluator, Supplier<C> collectionSupplier) {
        Collection result = (Collection)collectionSupplier.get();
        Comparable greatestValue = null;
        for (T element : collection) {
            int comparison;
            Comparable value = (Comparable)evaluator.apply(element);
            int n = comparison = greatestValue == null ? 1 : value.compareTo(greatestValue);
            if (comparison > 0) {
                greatestValue = value;
                result.clear();
                result.add(element);
                continue;
            }
            if (comparison != 0) continue;
            result.add(element);
        }
        return (C)result;
    }

    public static <T> Collection<T> difference(Collection<T> left, Collection<T> right) {
        return left.isEmpty() || right.isEmpty() ? left : (Collection)left.stream().filter(it -> !right.contains(it)).collect(Collectors.toList());
    }

    private static <T, C extends Collection<T>> C binaryStride(List<T> source, int cycle, Supplier<C> resultCreator) {
        Collection result = (Collection)resultCreator.get();
        Collecting.binaryStride(source, cycle, result::add);
        return (C)result;
    }

    private static <T> void binaryStride(List<T> source, int cycle, Consumer<T> accumulator) {
        int blockSize = 1 << cycle / 2;
        int parity = cycle % 2;
        int stopIndex = Calculation.greatestPowerOfTwoIn(source.size() + 1);
        for (int index = blockSize * parity; index < stopIndex; index += blockSize * 2) {
            int stopBlockIndex = Math.min(blockSize, source.size() - index);
            for (int blockIndex = 0; blockIndex < stopBlockIndex; ++blockIndex) {
                accumulator.accept(source.get(index + blockIndex));
            }
        }
        int remaining = source.size() - stopIndex;
        if (remaining > 1) {
            int maxCycle = Collecting.totalBinaryStrides(remaining) - 2 + parity;
            Collecting.binaryStride(source.subList(stopIndex, source.size()), Math.min(cycle, maxCycle), accumulator);
        } else if (remaining == 1 && parity == 0) {
            accumulator.accept(source.get(stopIndex));
        }
    }

    private static int totalBinaryStrides(int size) {
        return 2 * Calculation.binaryLogOf(size + 1);
    }
}

