/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.util;

import io.atleon.util.Configurable;
import io.atleon.util.Instantiation;
import java.net.URI;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class ConfigLoading {
    private ConfigLoading() {
    }

    public static <T extends Configurable> T loadConfiguredOrThrow(Map<String, ?> configs, String property, Class<? extends T> type) {
        return (T)((Configurable)ConfigLoading.loadConfiguredWithPredefinedTypes(configs, property, type, typeName -> Optional.empty()).orElseThrow(ConfigLoading.supplyMissingConfigPropertyException(property)));
    }

    public static Duration loadDurationOrThrow(Map<String, ?> configs, String property) {
        return ConfigLoading.loadDuration(configs, property).orElseThrow(ConfigLoading.supplyMissingConfigPropertyException(property));
    }

    public static boolean loadBooleanOrThrow(Map<String, ?> configs, String property) {
        return ConfigLoading.loadBoolean(configs, property).orElseThrow(ConfigLoading.supplyMissingConfigPropertyException(property));
    }

    public static int loadIntOrThrow(Map<String, ?> configs, String property) {
        return ConfigLoading.loadInt(configs, property).orElseThrow(ConfigLoading.supplyMissingConfigPropertyException(property));
    }

    public static long loadLongOrThrow(Map<String, ?> configs, String property) {
        return ConfigLoading.loadLong(configs, property).orElseThrow(ConfigLoading.supplyMissingConfigPropertyException(property));
    }

    public static String loadStringOrThrow(Map<String, ?> configs, String property) {
        return ConfigLoading.loadString(configs, property).orElseThrow(ConfigLoading.supplyMissingConfigPropertyException(property));
    }

    public static <T extends Configurable> Optional<T> loadConfiguredWithPredefinedTypes(Map<String, ?> configs, String property, Class<? extends T> type, Function<String, Optional<T>> predefinedTypeInstantiator) {
        Function instantiator = ConfigLoading.newInstantiatorWithPredefinedTypes(type, predefinedTypeInstantiator);
        Optional<Configurable> result = ConfigLoading.load(configs, property, value -> (Configurable)ConfigLoading.coerce(type, value, instantiator));
        result.ifPresent(configurable -> configurable.configure(configs));
        return result;
    }

    public static Optional<URI> loadUri(Map<String, ?> configs, String property) {
        return ConfigLoading.loadParseable(configs, property, URI.class, URI::create);
    }

    public static Optional<Duration> loadDuration(Map<String, ?> configs, String property) {
        return ConfigLoading.loadParseable(configs, property, Duration.class, Duration::parse);
    }

    public static Optional<Boolean> loadBoolean(Map<String, ?> configs, String property) {
        return ConfigLoading.loadParseable(configs, property, Boolean.class, Boolean::parseBoolean);
    }

    public static Optional<Integer> loadInt(Map<String, ?> configs, String property) {
        return ConfigLoading.loadParseable(configs, property, Number.class, Integer::parseInt).map(Number::intValue);
    }

    public static Optional<Long> loadLong(Map<String, ?> configs, String property) {
        return ConfigLoading.loadParseable(configs, property, Number.class, Long::parseLong).map(Number::longValue);
    }

    public static Optional<String> loadString(Map<String, ?> configs, String property) {
        return ConfigLoading.loadParseable(configs, property, String.class, Function.identity());
    }

    public static <T> Optional<T> loadParseable(Map<String, ?> configs, String property, Class<T> type, Function<? super String, T> parser) {
        return ConfigLoading.load(configs, property, value -> ConfigLoading.coerce(type, value, parser));
    }

    public static <T extends Configurable> List<T> loadListOfConfiguredServices(Class<? extends T> type, Map<String, ?> configs) {
        ServiceLoader<T> serviceLoader = ServiceLoader.load(type);
        return StreamSupport.stream(serviceLoader.spliterator(), false).peek(configurable -> configurable.configure(configs)).collect(Collectors.toList());
    }

    public static <T> List<T> loadListOfInstancesOrEmpty(Map<String, ?> configs, String property, Class<T> type) {
        return ConfigLoading.loadListOfInstances(configs, property, type).orElse(Collections.emptyList());
    }

    public static Set<String> loadSetOfStringOrEmpty(Map<String, ?> configs, String property) {
        return ConfigLoading.loadSetOfString(configs, property).orElse(Collections.emptySet());
    }

    public static <T extends Configurable> Optional<List<T>> loadListOfConfiguredWithPredefinedTypes(Map<String, ?> configs, String property, Class<? extends T> type, Function<String, Optional<T>> predefinedTypeInstantiator) {
        Optional<List<List>> result = ConfigLoading.loadListOfInstancesWithPredefinedTypes(configs, property, type, predefinedTypeInstantiator);
        result.ifPresent(configurables -> configurables.forEach(configurable -> configurable.configure(configs)));
        return result;
    }

    public static <T> Optional<List<T>> loadListOfInstances(Map<String, ?> configs, String property, Class<T> type) {
        return ConfigLoading.loadListOfInstancesWithPredefinedTypes(configs, property, type, typeName -> Optional.empty());
    }

    public static <T> Optional<List<T>> loadListOfInstancesWithPredefinedTypes(Map<String, ?> configs, String property, Class<? extends T> type, Function<String, Optional<T>> predefinedTypeInstantiator) {
        Function instantiator = ConfigLoading.newInstantiatorWithPredefinedTypes(type, predefinedTypeInstantiator);
        return ConfigLoading.loadStream(configs, property, value -> ConfigLoading.coerce(type, value, instantiator)).map(stream -> stream.collect(Collectors.toList()));
    }

    public static Optional<Set<String>> loadSetOfString(Map<String, ?> configs, String property) {
        return ConfigLoading.loadStream(configs, property, Objects::toString).map(stream -> stream.collect(Collectors.toCollection(LinkedHashSet::new)));
    }

    private static <T> Optional<T> load(Map<String, ?> configs, String property, Function<Object, T> coercer) {
        return Optional.ofNullable(configs.get(property)).map(coercer);
    }

    private static <T> Optional<Stream<T>> loadStream(Map<String, ?> configs, String property, Function<Object, T> coercer) {
        return Optional.ofNullable(configs.get(property)).map(value -> ConfigLoading.convertToStream(value).map(coercer));
    }

    private static Stream<?> convertToStream(Object value) {
        if (value instanceof Collection) {
            return ((Collection)Collection.class.cast(value)).stream();
        }
        if (value instanceof CharSequence) {
            return Stream.of(value.toString().split(",")).map(String::trim);
        }
        return Stream.of(value);
    }

    private static <T> Function<String, T> newInstantiatorWithPredefinedTypes(Class<? extends T> type, Function<String, Optional<T>> predefinedTypeInstantiator) {
        return typeName -> ((Optional)predefinedTypeInstantiator.apply((String)typeName)).orElseGet(() -> Instantiation.oneTyped(type, typeName, new Object[0]));
    }

    private static <T> T coerce(Class<? extends T> toType, Object value, Function<? super String, T> parser) {
        if (toType.isInstance(value)) {
            return toType.cast(value);
        }
        if (value instanceof Class) {
            return Instantiation.oneTyped(toType, (Class)Class.class.cast(value), new Object[0]);
        }
        if (value instanceof CharSequence) {
            return parser.apply(value.toString());
        }
        throw new UnsupportedOperationException("Cannot coerce value=" + value + " to object of type=" + toType);
    }

    private static Supplier<RuntimeException> supplyMissingConfigPropertyException(String property) {
        return () -> new IllegalArgumentException("Missing config: " + property);
    }
}

