/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ConfigLoading {
    private ConfigLoading() {
    }

    public static <T> T load(Map<String, ?> configs, String property, Function<? super String, T> parser, T defaultValue) {
        return ConfigLoading.load(configs, property, parser).orElse(defaultValue);
    }

    public static <T> T loadOrThrow(Map<String, ?> configs, String property, Function<? super String, T> parser) {
        return ConfigLoading.load(configs, property, parser).orElseThrow(ConfigLoading.supplyMissingConfigPropertyException(property));
    }

    public static <T> Optional<T> load(Map<String, ?> configs, String property, Function<? super String, T> parser) {
        return Optional.ofNullable(configs.get(property)).map(Object::toString).map(parser);
    }

    public static <T, R> R loadCollectionOrThrow(Map<String, ?> configs, String property, Function<? super String, T> parser, Collector<? super T, ?, R> collector) {
        return ConfigLoading.loadCollection(configs, property, parser, collector).orElseThrow(ConfigLoading.supplyMissingConfigPropertyException(property));
    }

    public static <T> List<T> loadListOrEmpty(Map<String, ?> configs, String property, Function<? super String, T> parser) {
        return ConfigLoading.loadCollection(configs, property, parser, Collectors.toList()).orElse(Collections.emptyList());
    }

    public static <T> Set<T> loadSetOrEmpty(Map<String, ?> configs, String property, Function<? super String, T> parser) {
        return ConfigLoading.loadCollection(configs, property, parser, Collectors.toSet()).orElse(Collections.emptySet());
    }

    public static <T, R> Optional<R> loadCollection(Map<String, ?> configs, String property, Function<? super String, T> parser, Collector<? super T, ?, R> collector) {
        return Optional.ofNullable(configs.get(property)).map(ConfigLoading::convertToCollection).map(collection -> collection.stream().map(Objects::toString).map(parser).collect(collector));
    }

    public static Map<String, Object> loadPrefixedEnvironmentalProperties(String prefix) {
        return Stream.of(System.getenv().entrySet(), System.getProperties().entrySet()).flatMap(Collection::stream).filter(entry -> Objects.toString(entry.getKey()).startsWith(prefix)).collect(Collectors.toMap(entry -> entry.getKey().toString().substring(prefix.length()), Map.Entry::getValue, (firstValue, secondValue) -> secondValue));
    }

    public static <T> Map<String, T> loadPrefixed(Map<String, ?> configs, String prefix, Function<? super String, T> parser) {
        return configs.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(prefix)).collect(Collectors.toMap(entry -> ((String)entry.getKey()).substring(prefix.length()), entry -> parser.apply(entry.getValue().toString())));
    }

    private static Collection<?> convertToCollection(Object config) {
        if (config instanceof Collection) {
            return (Collection)Collection.class.cast(config);
        }
        if (config instanceof CharSequence) {
            return Arrays.asList(config.toString().split(","));
        }
        return Collections.singletonList(config);
    }

    private static Supplier<RuntimeException> supplyMissingConfigPropertyException(String property) {
        return () -> new IllegalArgumentException("Missing config: " + property);
    }
}

