/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.spring;

import io.atleon.aws.sns.SnsConfigSource;
import io.atleon.aws.sqs.SqsConfigSource;
import io.atleon.core.ConfigSource;
import io.atleon.kafka.KafkaConfigSource;
import io.atleon.rabbitmq.RabbitMQConfigSource;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.core.ResolvableType;
import org.springframework.core.env.Environment;

public class ConfigSourcesRegistrar
implements BeanDefinitionRegistryPostProcessor {
    private static final String SPECS_PROPERTY = "atleon.config.sources";
    private static final ResolvableType ENTRIES_TYPE = ResolvableType.forClassWithGenerics(List.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forClassWithGenerics(Map.class, (Class[])new Class[]{String.class, String.class})});
    private final List<Map<String, ?>> specs;

    public ConfigSourcesRegistrar(Environment environment) {
        this.specs = (List)Binder.get((Environment)environment).bind(SPECS_PROPERTY, Bindable.of((ResolvableType)ENTRIES_TYPE)).orElse(Collections.emptyList());
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        this.specs.forEach(it -> ConfigSourcesRegistrar.register(it, (arg_0, arg_1) -> ((BeanDefinitionRegistry)registry).registerBeanDefinition(arg_0, arg_1)));
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    private static void register(Map<String, ?> spec, BiConsumer<String, BeanDefinition> registrar) {
        HashMap mutableSpec = new HashMap(spec);
        String name = Objects.requireNonNull(mutableSpec.remove("name"), "Spec must have name").toString();
        String type = Objects.requireNonNull(mutableSpec.remove("type"), "Spec must have type").toString();
        registrar.accept(name, ConfigSourcesRegistrar.newDefinition(type, name, mutableSpec));
    }

    private static BeanDefinition newDefinition(String type, String name, Map<String, ?> properties) {
        switch (type) {
            case "kafka": {
                return ConfigSourcesRegistrar.newDefinition(KafkaConfigSource.class, () -> (KafkaConfigSource)KafkaConfigSource.named((String)name).withAll(properties));
            }
            case "rabbitMQ": {
                return ConfigSourcesRegistrar.newDefinition(RabbitMQConfigSource.class, () -> (RabbitMQConfigSource)RabbitMQConfigSource.named((String)name).withAll(properties));
            }
            case "sns": {
                return ConfigSourcesRegistrar.newDefinition(SnsConfigSource.class, () -> (SnsConfigSource)SnsConfigSource.named((String)name).withAll(properties));
            }
            case "sqs": {
                return ConfigSourcesRegistrar.newDefinition(SqsConfigSource.class, () -> (SqsConfigSource)SqsConfigSource.named((String)name).withAll(properties));
            }
        }
        throw new IllegalArgumentException("Unsupported config source type: " + type);
    }

    private static <T, S extends ConfigSource<T, S>> BeanDefinition newDefinition(Class<S> type, Supplier<S> supplier) {
        return BeanDefinitionBuilder.rootBeanDefinition(type, supplier).getBeanDefinition();
    }
}

