/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.application;

import io.atleon.core.AloStream;
import io.atleon.core.AloStreamConfig;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class AloStreamCompatibility {
    private AloStreamCompatibility() {
    }

    public static <C extends AloStreamConfig> Optional<AloStream<? super C>> findSingleCompatibleStream(Collection<? extends AloStream<?>> registeredStreams, C config) {
        List compatibleStreams = registeredStreams.stream().filter(stream -> AloStreamCompatibility.isCompatible(stream.getClass(), config)).map(stream -> stream).collect(Collectors.toList());
        if (compatibleStreams.isEmpty()) {
            return Optional.empty();
        }
        if (compatibleStreams.size() == 1) {
            return Optional.of((AloStream)compatibleStreams.get(0));
        }
        throw new IllegalStateException("There is more than one registered stream compatible with config=" + config);
    }

    public static boolean isCompatible(Class<? extends AloStream<?>> streamType, AloStreamConfig config) {
        return AloStreamCompatibility.deduceConfigType(streamType).isAssignableFrom(config.getClass());
    }

    private static Class<?> deduceConfigType(Class<? extends AloStream<?>> streamType) {
        for (Class<AloStream<?>> type = streamType; type != null; type = type.getSuperclass()) {
            if (!type.getSuperclass().equals(AloStream.class)) continue;
            ParameterizedType aloStreamType = (ParameterizedType)ParameterizedType.class.cast(type.getGenericSuperclass());
            return AloStreamCompatibility.extractRawType(aloStreamType.getActualTypeArguments()[0]);
        }
        throw new IllegalStateException("Failed to deduce configType for streamType=" + streamType);
    }

    private static Class<?> extractRawType(Type type) {
        if (type instanceof Class) {
            return (Class)Class.class.cast(type);
        }
        if (type instanceof ParameterizedType) {
            return AloStreamCompatibility.extractRawType(((ParameterizedType)ParameterizedType.class.cast(type)).getRawType());
        }
        throw new IllegalArgumentException("Cannot extract raw type from type=" + type);
    }
}

