/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.spring;

import io.atleon.application.AloStreamCompatibility;
import io.atleon.application.ConfiguredAloStream;
import io.atleon.core.AloStream;
import io.atleon.core.AloStreamConfig;
import io.atleon.spring.AloStreamApplicationListener;
import io.atleon.spring.AutoConfigureStream;
import io.atleon.spring.Contexts;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Configuration(proxyBeanMethods=false)
public class AloStreamAutoConfiguration {
    @Bean
    @Conditional(value={AutoConfigureStreamEnabled.class})
    public List<ConfiguredAloStream> autoConfiguredAloStreams(ConfigurableApplicationContext context, List<AloStreamConfig> configs) {
        ArrayList<ConfiguredAloStream> configuredAloStreams = new ArrayList<ConfiguredAloStream>();
        Set uniqueStreams = Collections.newSetFromMap(new IdentityHashMap());
        for (AloStreamConfig config : configs) {
            if (!config.getClass().isAnnotationPresent(AutoConfigureStream.class)) continue;
            AloStream<AloStreamConfig> stream = this.findOrCreateStream(context, config);
            if (uniqueStreams.add(stream)) {
                AloStreamApplicationListener<AloStreamConfig> listener = new AloStreamApplicationListener<AloStreamConfig>(stream, config);
                context.addApplicationListener(listener);
                configuredAloStreams.add(listener);
                continue;
            }
            throw new IllegalStateException("Instance of stream=" + stream + " applicable to more than one config!");
        }
        return configuredAloStreams;
    }

    private <C extends AloStreamConfig> AloStream<? super C> findOrCreateStream(ConfigurableApplicationContext context, C config) {
        AutoConfigureStream annotation = config.getClass().getDeclaredAnnotation(AutoConfigureStream.class);
        Class<? extends AloStream> streamType = annotation.value();
        Optional<AloStream<C>> compatibleStream = AloStreamCompatibility.findSingleCompatibleStream(context.getBeansOfType(streamType).values(), config);
        if (compatibleStream.isPresent()) {
            return compatibleStream.get();
        }
        if (streamType.equals(AloStream.class)) {
            throw new IllegalStateException("Could not find compatible stream for config=" + config);
        }
        if (AloStreamCompatibility.isCompatible(streamType, config)) {
            return (AloStream)context.getBeanFactory().createBean(streamType);
        }
        throw new IllegalStateException("stream=" + streamType + " is incompatible with config=" + config);
    }

    public static final class AutoConfigureStreamEnabled
    implements Condition {
        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return !Contexts.isPropertySetToFalse(context, "atleon.stream.configure.auto.enabled");
        }
    }
}

