/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.spring;

import io.atleon.spring.AloStreamStatusDto;
import io.atleon.spring.AloStreamStatusService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.util.Collection;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/${atleon.management.rest.path:atleonManagement}"}, produces={"application/json"})
public class AtleonManagementController {
    private final AloStreamStatusService streamStatusService;

    AtleonManagementController(AloStreamStatusService streamStatusService) {
        this.streamStatusService = streamStatusService;
    }

    @Operation(summary="Get statuses of all Streams")
    @GetMapping(value={"streams"})
    public ResponseEntity<Collection<AloStreamStatusDto>> getAllStreamStatuses() {
        return ResponseEntity.ok(this.streamStatusService.getAllStatuses());
    }

    @Operation(summary="Get status of a single Stream")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Stream found"), @ApiResponse(responseCode="404", description="Stream not found")})
    @GetMapping(value={"streams/{name}"})
    public ResponseEntity<AloStreamStatusDto> getStreamStatus(@PathVariable(value="name") String name) {
        return ResponseEntity.of(this.streamStatusService.getStatus(name));
    }

    @Operation(summary="Start a Stream")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Stream found and started"), @ApiResponse(responseCode="404", description="Stream not found")})
    @PutMapping(value={"streams/{name}/start"})
    public ResponseEntity<AloStreamStatusDto> startStream(@PathVariable(value="name") String name) {
        return ResponseEntity.of(this.streamStatusService.start(name));
    }

    @Operation(summary="Stop a Stream")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Stream found and stopped"), @ApiResponse(responseCode="404", description="Stream not found")})
    @PutMapping(value={"streams/{name}/stop"})
    public ResponseEntity<AloStreamStatusDto> stopStream(@PathVariable(value="name") String name) {
        return ResponseEntity.of(this.streamStatusService.stop(name));
    }
}

