/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.spring;

import io.atleon.core.AloStream;
import io.atleon.core.AloStreamConfig;
import io.atleon.spring.AloStreamApplicationListener;
import io.atleon.spring.AutoConfigureStream;
import io.atleon.spring.ConfiguredAloStream;
import io.atleon.spring.Contexts;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Configuration(proxyBeanMethods=false)
public class AloStreamAutoConfiguration {
    @Bean
    @Conditional(value={AutoConfigureStreamEnabled.class})
    public List<ConfiguredAloStream> autoConfiguredAloStreams(ConfigurableApplicationContext context, List<AloStreamConfig> configs) {
        ArrayList<ConfiguredAloStream> configuredAloStreams = new ArrayList<ConfiguredAloStream>();
        Set uniqueStreams = Collections.newSetFromMap(new IdentityHashMap());
        for (AloStreamConfig config : configs) {
            if (!config.getClass().isAnnotationPresent(AutoConfigureStream.class)) continue;
            AloStream<AloStreamConfig> stream = this.findOrCreateStream(context, config);
            if (uniqueStreams.add(stream)) {
                AloStreamApplicationListener<AloStreamConfig> listener = new AloStreamApplicationListener<AloStreamConfig>(stream, config);
                context.addApplicationListener(listener);
                configuredAloStreams.add(listener);
                continue;
            }
            throw new IllegalStateException("Instance of stream=" + stream + " applicable to more than one config!");
        }
        return configuredAloStreams;
    }

    private <C extends AloStreamConfig> AloStream<? super C> findOrCreateStream(ConfigurableApplicationContext context, C config) {
        AutoConfigureStream annotation = config.getClass().getDeclaredAnnotation(AutoConfigureStream.class);
        Optional<AloStream<C>> compatibleStream = this.findCompatibleStream(context, config, annotation.value());
        if (compatibleStream.isPresent()) {
            return compatibleStream.get();
        }
        if (annotation.value().equals(AloStream.class)) {
            throw new IllegalStateException("Could not find compatible stream for config=" + config);
        }
        if (AloStreamAutoConfiguration.isCompatible(annotation.value(), config)) {
            return (AloStream)context.getBeanFactory().createBean(annotation.value());
        }
        throw new IllegalStateException("stream=" + annotation.value() + " is incompatible with config=" + config);
    }

    private <C extends AloStreamConfig> Optional<AloStream<? super C>> findCompatibleStream(ConfigurableApplicationContext context, C config, Class<? extends AloStream> streamType) {
        List compatibleStreams = context.getBeansOfType(streamType).values().stream().filter(stream -> AloStreamAutoConfiguration.isCompatible(stream.getClass(), config)).collect(Collectors.toList());
        if (compatibleStreams.isEmpty()) {
            return Optional.empty();
        }
        if (compatibleStreams.size() == 1) {
            return Optional.of((AloStream)compatibleStreams.get(0));
        }
        throw new IllegalStateException("There is more than one registered stream compatible with config=" + config);
    }

    private static boolean isCompatible(Class<? extends AloStream> streamType, AloStreamConfig config) {
        return AloStreamAutoConfiguration.deduceConfigType(streamType).isAssignableFrom(config.getClass());
    }

    private static Class<?> deduceConfigType(Class<? extends AloStream> streamType) {
        for (Class<? extends AloStream> type = streamType; type != null; type = type.getSuperclass()) {
            if (!type.getSuperclass().equals(AloStream.class)) continue;
            ParameterizedType aloStreamType = (ParameterizedType)ParameterizedType.class.cast(type.getGenericSuperclass());
            Type configType = aloStreamType.getActualTypeArguments()[0];
            return (Class)Class.class.cast(configType);
        }
        throw new IllegalStateException("Failed to deduce configType for streamType=" + streamType);
    }

    public static final class AutoConfigureStreamEnabled
    implements Condition {
        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return !Contexts.isPropertySetToFalse(context, "atleon.stream.configure.auto.enabled");
        }
    }
}

