/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.rabbitmq;

import io.atleon.core.Alo;
import io.atleon.rabbitmq.RabbitMQSenderResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.BaseSubscriber;

public class DefaultAloRabbitMQSenderResultSubscriber<T>
extends BaseSubscriber<Alo<RabbitMQSenderResult<T>>> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DefaultAloRabbitMQSenderResultSubscriber.class);

    protected void hookOnNext(Alo<RabbitMQSenderResult<T>> aloResult) {
        RabbitMQSenderResult result = (RabbitMQSenderResult)aloResult.get();
        if (result.isAck()) {
            Alo.acknowledge(aloResult);
        } else {
            LOGGER.warn("RabbitMQ Sender Result is not an ack: result={}", (Object)result);
            Alo.nacknowledge(aloResult, (Throwable)new UnackedRabbitMQSenderResultException());
        }
    }

    private static final class UnackedRabbitMQSenderResultException
    extends Exception {
        private UnackedRabbitMQSenderResultException() {
        }
    }
}

