/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.protobuf;

import com.google.protobuf.Message;
import io.atleon.protobuf.ProtobufMessages;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.kafka.common.serialization.Deserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProtobufKafkaDeserializer<T extends Message>
implements Deserializer<T> {
    public static final String KEY_MESSAGE_TYPE_CONFIG = "protobuf.key.message.type";
    public static final String VALUE_MESSAGE_TYPE_CONFIG = "protobuf.value.message.type";
    @Deprecated
    public static final String MESSAGE_TYPE_CONFIG = "protobuf.message.type";
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtobufKafkaDeserializer.class);
    private Function<byte[], T> parser;

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.parser = ProtobufKafkaDeserializer.loadParser(configs, isKey ? KEY_MESSAGE_TYPE_CONFIG : VALUE_MESSAGE_TYPE_CONFIG);
    }

    public T deserialize(String topic, byte[] data) {
        return (T)(data == null ? null : (Message)this.parser.apply(data));
    }

    private static <T extends Message> Function<byte[], T> loadParser(Map<String, ?> configs, String specificKey) {
        Optional parser = ProtobufMessages.loadParser(configs, specificKey, byte[].class);
        if (parser.isPresent()) {
            return parser.get();
        }
        parser = ProtobufMessages.loadParser(configs, MESSAGE_TYPE_CONFIG, byte[].class);
        if (parser.isPresent()) {
            LOGGER.warn("Deprecated config '{}'. Please configure '{}'.", (Object)MESSAGE_TYPE_CONFIG, (Object)specificKey);
            return parser.get();
        }
        throw new IllegalArgumentException("Missing config: " + specificKey);
    }
}

