/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.micrometer;

import io.atleon.core.Alo;
import io.atleon.core.AloDecorator;
import io.atleon.micrometer.MeterFacade;
import io.atleon.micrometer.MeterKey;
import io.atleon.micrometer.TypeKey;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public abstract class MeteringAloDecorator<T, K>
implements AloDecorator<T> {
    private final MeterFacade<TypeKey<AloMeterType, K>> meterFacade;

    protected MeteringAloDecorator(String name) {
        this((MeterRegistry)Metrics.globalRegistry, name);
    }

    protected MeteringAloDecorator(MeterRegistry meterRegistry, String name) {
        this.meterFacade = MeterFacade.create(meterRegistry, it -> this.toMeterKey(name, (TypeKey<AloMeterType, K>)it));
    }

    public void configure(Map<String, ?> properties) {
        this.meterFacade.clear();
    }

    public int order() {
        return -2147479648;
    }

    public final Alo<T> decorate(Alo<T> alo) {
        Object data = alo.get();
        K key = this.extractKey(data);
        Timer successTimer = this.meterFacade.timer(new TypeKey<AloMeterType, K>(AloMeterType.SUCCESS_TIMER, key));
        Timer failureTimer = this.meterFacade.timer(new TypeKey<AloMeterType, K>(AloMeterType.FAILURE_TIMER, key));
        long startedAtNano = System.nanoTime();
        Runnable acknowledger = MeteringAloDecorator.applyMetering(alo.getAcknowledger(), successTimer, startedAtNano);
        Consumer<Throwable> nacknowledger = MeteringAloDecorator.applyMetering(alo.getNacknowledger(), failureTimer, startedAtNano);
        return alo.propagator().create(data, acknowledger, nacknowledger);
    }

    protected abstract K extractKey(T var1);

    protected final MeterKey toMeterKey(String name, TypeKey<AloMeterType, K> typeKey) {
        switch (typeKey.type()) {
            case SUCCESS_TIMER: {
                return new MeterKey(name + ".duration", Tags.of((String)"result", (String)"success").and(this.extractTags(typeKey.key())));
            }
            case FAILURE_TIMER: {
                return new MeterKey(name + ".duration", Tags.of((String)"result", (String)"failure").and(this.extractTags(typeKey.key())));
            }
        }
        throw new IllegalStateException("Unimplemented aloMeterType=" + (Object)((Object)typeKey.type()));
    }

    protected abstract Iterable<Tag> extractTags(K var1);

    private static Runnable applyMetering(Runnable acknowledger, Timer timer, long startedAtNano) {
        return () -> {
            try {
                acknowledger.run();
            }
            finally {
                timer.record(System.nanoTime() - startedAtNano, TimeUnit.NANOSECONDS);
            }
        };
    }

    private static Consumer<Throwable> applyMetering(Consumer<? super Throwable> nacknowledger, Timer timer, long startedAtNano) {
        return error -> {
            try {
                nacknowledger.accept((Throwable)error);
            }
            finally {
                timer.record(System.nanoTime() - startedAtNano, TimeUnit.NANOSECONDS);
            }
        };
    }

    private static enum AloMeterType {
        SUCCESS_TIMER,
        FAILURE_TIMER;

    }
}

