/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.core;

import io.atleon.core.AloDecorator;
import io.atleon.util.ConfigLoading;
import io.atleon.util.Instantiation;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class AloDecoratorConfig {
    public static final String DESCRIPTOR_AUTO = "auto";

    private AloDecoratorConfig() {
    }

    public static <T, C extends AloDecorator<T>> Optional<AloDecorator<T>> load(Class<C> type, Map<String, ?> properties, String descriptorProperty) {
        Set descriptors = ConfigLoading.loadSetOrEmpty(properties, (String)descriptorProperty, Function.identity());
        List decorators = descriptors.stream().flatMap(descriptor -> AloDecoratorConfig.instantiate(type, descriptor)).peek(decorator -> decorator.configure(properties)).collect(Collectors.toList());
        return decorators.isEmpty() ? Optional.empty() : Optional.of(AloDecorator.combine(decorators));
    }

    private static <T, C extends AloDecorator<T>> Stream<C> instantiate(Class<C> type, String descriptor) {
        if (descriptor.equalsIgnoreCase(DESCRIPTOR_AUTO)) {
            ServiceLoader<C> serviceLoader = ServiceLoader.load(type);
            return StreamSupport.stream(serviceLoader.spliterator(), false);
        }
        return Stream.of(descriptor).map(x$0 -> Instantiation.one((String)x$0, (Object[])new Object[0])).map(type::cast);
    }
}

