/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.core;

import io.atleon.core.Alo;
import io.atleon.util.Configurable;
import java.util.List;
import java.util.Map;

@FunctionalInterface
public interface AloDecorator<T>
extends Configurable {
    public static <T> AloDecorator<T> combine(List<AloDecorator<T>> decorators) {
        return decorators.size() == 1 ? decorators.get(0) : new Composite(decorators);
    }

    default public void configure(Map<String, ?> properties) {
    }

    public Alo<T> decorate(Alo<T> var1);

    public static class Composite<T>
    implements AloDecorator<T> {
        private final List<AloDecorator<T>> decorators;

        private Composite(List<AloDecorator<T>> decorators) {
            this.decorators = decorators;
        }

        @Override
        public Alo<T> decorate(Alo<T> alo) {
            for (AloDecorator<T> decorator : this.decorators) {
                alo = decorator.decorate(alo);
            }
            return alo;
        }
    }
}

