/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.core;

import com.google.common.util.concurrent.RateLimiter;
import io.atleon.core.RateLimitingConfig;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

final class RateLimitingTransformer<T>
implements Function<Publisher<T>, Publisher<T>> {
    private final UnaryOperator<Publisher<T>> rateLimiter;

    RateLimitingTransformer(RateLimitingConfig config) {
        this.rateLimiter = config.isEnabled() ? this.createRateLimiter(config) : UnaryOperator.identity();
    }

    @Override
    public Publisher<T> apply(Publisher<T> publisher) {
        return (Publisher)this.rateLimiter.apply(publisher);
    }

    private UnaryOperator<Publisher<T>> createRateLimiter(RateLimitingConfig config) {
        RateLimiter rateLimiter = RateLimiter.create((double)config.getPermitsPerSecond());
        return publisher -> Flux.from((Publisher)publisher).doOnNext(t -> rateLimiter.acquire());
    }
}

