/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.core;

import java.util.function.BinaryOperator;
import java.util.function.Function;

public interface Deduplication<T> {
    public static <T> Deduplication<T> identity() {
        return Deduplication.emitFirst(Function.identity());
    }

    public static <T> Deduplication<T> emitFirst(Function<? super T, ?> keyExtractor) {
        return Deduplication.composed(keyExtractor, (first, __) -> first);
    }

    public static <T> Deduplication<T> emitLast(Function<? super T, ?> keyExtractor) {
        return Deduplication.composed(keyExtractor, (__, second) -> second);
    }

    public static <T> Deduplication<T> composed(Function<? super T, ?> keyExtractor, BinaryOperator<T> reducer) {
        return new Composed(keyExtractor, reducer);
    }

    public Object extractKey(T var1);

    public T reduceDuplicates(T var1, T var2);

    public static class Composed<T>
    implements Deduplication<T> {
        private final Function<? super T, ?> keyExtractor;
        private final BinaryOperator<T> reducer;

        private Composed(Function<? super T, ?> keyExtractor, BinaryOperator<T> reducer) {
            this.keyExtractor = keyExtractor;
            this.reducer = reducer;
        }

        @Override
        public Object extractKey(T t) {
            return this.keyExtractor.apply(t);
        }

        @Override
        public T reduceDuplicates(T first, T second) {
            return (T)this.reducer.apply(first, second);
        }
    }
}

