/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.core;

import io.atleon.core.ConfigInterceptor;
import io.atleon.core.ConfigProcessor;
import io.atleon.core.ConfigProvider;
import io.atleon.util.ConfigLoading;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public abstract class ConfigSource<T, S extends ConfigSource<T, S>>
extends ConfigProvider<Mono<T>, S> {
    public static final String PROCESSORS_PROPERTY = "atleon.config.processors";

    protected ConfigSource() {
    }

    protected ConfigSource(String name) {
        super(name);
    }

    protected ConfigSource(Function<Map<String, Object>, Optional<String>> propertiesToName) {
        super(propertiesToName);
    }

    @Override
    protected final Mono<T> create(String name, Map<String, Object> properties) {
        return this.applyProcessors(name, properties).doOnNext(this::validateProperties).map(this::postProcessProperties);
    }

    @Override
    protected final Mono<T> create(Map<String, Object> properties) {
        return this.applyProcessors(properties).doOnNext(this::validateProperties).map(this::postProcessProperties);
    }

    protected final Mono<Map<String, Object>> applyProcessors(String name, Map<String, Object> properties) {
        Mono result = Mono.just(properties);
        for (ConfigProcessor processor : this.loadProcessors(properties)) {
            result = result.flatMap(configs -> processor.process(name, (Map<String, Object>)configs));
        }
        return result;
    }

    protected final Mono<Map<String, Object>> applyProcessors(Map<String, Object> properties) {
        Mono result = Mono.just(properties);
        for (ConfigProcessor processor : this.loadProcessors(properties)) {
            result = result.flatMap(processor::process);
        }
        return result;
    }

    protected List<ConfigProcessor> loadProcessors(Map<String, Object> properties) {
        List<ConfigProcessor> processors = this.defaultInterceptors().stream().map(ConfigInterceptor::asProcessor).collect(Collectors.toList());
        processors.addAll(ConfigLoading.loadListOfInstancesOrEmpty(properties, (String)PROCESSORS_PROPERTY, ConfigProcessor.class));
        return processors;
    }

    protected abstract void validateProperties(Map<String, Object> var1);

    protected abstract T postProcessProperties(Map<String, Object> var1);
}

