/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.context;

import io.atleon.context.AloContext;
import io.atleon.core.AbstractDecoratingAlo;
import io.atleon.core.Alo;
import io.atleon.core.AloFactory;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class ContextActivatingAlo<T>
extends AbstractDecoratingAlo<T> {
    private final AloContext context;

    private ContextActivatingAlo(Alo<T> delegate, AloContext context) {
        super(delegate);
        this.context = context;
    }

    public static <T> ContextActivatingAlo<T> create(Alo<T> delegate) {
        return new ContextActivatingAlo<T>(delegate, AloContext.create());
    }

    @Override
    public void runInContext(Runnable runnable) {
        this.context.run(() -> this.delegate.runInContext(runnable));
    }

    @Override
    public <R> R supplyInContext(Supplier<R> supplier) {
        return (R)this.context.supply(() -> this.delegate.supplyInContext(supplier));
    }

    @Override
    public <R> Alo<R> map(Function<? super T, ? extends R> mapper) {
        return new ContextActivatingAlo<T>(this.context.supply(() -> this.delegate.map(mapper)), this.context);
    }

    @Override
    public <R> AloFactory<List<R>> fanInPropagator(List<? extends Alo<?>> alos) {
        AloContext mergedContext = AloContext.create();
        for (Alo<?> alo2 : alos) {
            ContextActivatingAlo.doOnDelegator(alo2, ContextActivatingAlo.class, it -> mergedContext.merge(it.context()));
        }
        return this.delegate.fanInPropagator(alos).withDecorator(alo -> new ContextActivatingAlo(alo, mergedContext));
    }

    @Override
    public <R> AloFactory<R> propagator() {
        return this.delegate.propagator().withDecorator(alo -> new ContextActivatingAlo<T>(alo, this.context.copy()));
    }

    public AloContext context() {
        return this.context;
    }
}

