/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.core;

import io.atleon.core.AcknowledgementQueue;
import io.atleon.core.Alo;
import io.atleon.core.AloComponentExtractor;
import io.atleon.core.AloFactory;
import io.atleon.core.AloQueueListener;
import io.atleon.core.AloQueueingOperator;
import io.atleon.core.ComposedAlo;
import io.atleon.core.OrderManagingAcknowledgementQueue;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;

public final class AloQueueingTransformer<T, V>
implements Function<Publisher<T>, Publisher<Alo<V>>> {
    private final Function<T, ?> groupExtractor;
    private final Supplier<? extends AcknowledgementQueue> queueSupplier;
    private final AloQueueListener listener;
    private final AloComponentExtractor<T, V> componentExtractor;
    private final AloFactory<V> factory;
    private final long maxInFlight;

    private AloQueueingTransformer(Function<T, ?> groupExtractor, Supplier<? extends AcknowledgementQueue> queueSupplier, AloQueueListener listener, AloComponentExtractor<T, V> componentExtractor, AloFactory<V> factory, long maxInFlight) {
        this.groupExtractor = groupExtractor;
        this.queueSupplier = queueSupplier;
        this.listener = listener;
        this.componentExtractor = componentExtractor;
        this.factory = factory;
        this.maxInFlight = maxInFlight;
    }

    public static <T, V> AloQueueingTransformer<T, V> create(AloComponentExtractor<T, V> componentExtractor) {
        return new AloQueueingTransformer<Object, V>(__ -> "singleton", OrderManagingAcknowledgementQueue::create, AloQueueListener.noOp(), componentExtractor, ComposedAlo.factory(), Long.MAX_VALUE);
    }

    public AloQueueingTransformer<T, V> withGroupExtractor(Function<T, ?> groupExtractor) {
        return new AloQueueingTransformer<T, V>(groupExtractor, this.queueSupplier, this.listener, this.componentExtractor, this.factory, this.maxInFlight);
    }

    public AloQueueingTransformer<T, V> withListener(AloQueueListener listener) {
        return new AloQueueingTransformer<T, V>(this.groupExtractor, this.queueSupplier, listener, this.componentExtractor, this.factory, this.maxInFlight);
    }

    public AloQueueingTransformer<T, V> withFactory(AloFactory<V> factory) {
        return new AloQueueingTransformer<T, V>(this.groupExtractor, this.queueSupplier, this.listener, this.componentExtractor, factory, this.maxInFlight);
    }

    public AloQueueingTransformer<T, V> withMaxInFlight(long maxInFlight) {
        return new AloQueueingTransformer<T, V>(this.groupExtractor, this.queueSupplier, this.listener, this.componentExtractor, this.factory, maxInFlight);
    }

    @Override
    public Publisher<Alo<V>> apply(Publisher<T> publisher) {
        return new AloQueueingOperator<T, V>(publisher, this.groupExtractor, this.queueSupplier, this.listener, this.componentExtractor, this.factory, this.maxInFlight);
    }
}

