/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.core;

import io.atleon.core.ResubscriptionConfig;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.util.retry.Retry;

final class ResubscribingTransformer<T>
implements Function<Publisher<T>, Publisher<T>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResubscribingTransformer.class);
    private final ResubscriptionConfig config;

    ResubscribingTransformer(ResubscriptionConfig config) {
        this.config = config;
    }

    @Override
    public Publisher<T> apply(Publisher<T> publisher) {
        return this.config.isEnabled() ? this.applyResubscription(publisher) : publisher;
    }

    private Flux<T> applyResubscription(Publisher<T> publisher) {
        return Flux.from(publisher).retryWhen(Retry.from(this::scheduleResubscription));
    }

    private Flux<?> scheduleResubscription(Flux<Retry.RetrySignal> signals) {
        return signals.doOnNext(signal -> LOGGER.warn("An Error has occurred! Scheduling resubscription: name={} errorNo={} delay={}", new Object[]{this.config.getName(), signal.totalRetries() + 1L, this.config.getDelay(), signal.failure()})).delayElements(this.config.getDelay()).doOnNext(signal -> LOGGER.info("Attempting resubscription from Error: name={} errorNo={}", (Object)this.config.getName(), (Object)(signal.totalRetries() + 1L)));
    }
}

