/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.core;

import java.time.Duration;

public final class DeduplicationConfig {
    private final Duration deduplicationDuration;
    private final long maxDeduplicationSize;
    private final int deduplicationConcurrency;
    private final int deduplicationSourcePrefetch;

    public DeduplicationConfig(Duration deduplicationDuration) {
        this(deduplicationDuration, Long.MAX_VALUE);
    }

    public DeduplicationConfig(Duration deduplicationDuration, long maxDeduplicationSize) {
        this(deduplicationDuration, maxDeduplicationSize, Integer.MAX_VALUE);
    }

    public DeduplicationConfig(Duration deduplicationDuration, long maxDeduplicationSize, int deduplicationConcurrency) {
        this(deduplicationDuration, maxDeduplicationSize, deduplicationConcurrency, 256);
    }

    public DeduplicationConfig(Duration deduplicationDuration, long maxDeduplicationSize, int deduplicationConcurrency, int deduplicationSourcePrefetch) {
        this.deduplicationDuration = deduplicationDuration;
        this.maxDeduplicationSize = maxDeduplicationSize;
        this.deduplicationConcurrency = deduplicationConcurrency;
        this.deduplicationSourcePrefetch = deduplicationSourcePrefetch;
    }

    public boolean isEnabled() {
        return !this.deduplicationDuration.isNegative() && !this.deduplicationDuration.isZero();
    }

    public Duration getDeduplicationDuration() {
        return this.deduplicationDuration;
    }

    public long getMaxDeduplicationSize() {
        return this.maxDeduplicationSize;
    }

    public int getDeduplicationConcurrency() {
        return this.deduplicationConcurrency;
    }

    public int getDeduplicationSourcePrefetch() {
        return this.deduplicationSourcePrefetch;
    }
}

