/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.core;

import io.atleon.core.Alo;
import io.atleon.core.AloDecorator;
import io.atleon.util.ConfigLoading;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class AloDecoratorConfig {
    public static final String ALO_DECORATOR_TYPES_CONFIG = "alo.decorator.types";
    public static final String DECORATOR_TYPE_AUTO = "auto";

    private AloDecoratorConfig() {
    }

    public static <T, D extends AloDecorator<T>> Optional<AloDecorator<T>> load(Map<String, ?> properties, Class<D> superType) {
        List decorators = AloDecoratorConfig.loadExplicit(properties, superType).orElseGet(() -> ConfigLoading.loadListOfConfiguredServices((Class)superType, (Map)properties));
        return decorators.isEmpty() ? Optional.empty() : Optional.of(AloDecorator.combine(decorators));
    }

    private static <T, D extends AloDecorator<T>> Optional<List<AloDecorator<T>>> loadExplicit(Map<String, ?> properties, Class<D> superType) {
        return ConfigLoading.loadListOfConfiguredWithPredefinedTypes(properties, (String)ALO_DECORATOR_TYPES_CONFIG, superType, typeName -> AloDecoratorConfig.instantiatePredefined(properties, superType, typeName));
    }

    private static <T> Optional<AloDecorator<T>> instantiatePredefined(Map<String, ?> properties, Class<? extends AloDecorator<T>> superType, String typeName) {
        if (typeName.equalsIgnoreCase(DECORATOR_TYPE_AUTO)) {
            List decorators = ConfigLoading.loadListOfConfiguredServices(superType, properties);
            return Optional.of(decorators.isEmpty() ? new NoOpAloDecorator() : AloDecorator.combine(decorators));
        }
        return Optional.empty();
    }

    private static final class NoOpAloDecorator<T>
    implements AloDecorator<T> {
        private NoOpAloDecorator() {
        }

        @Override
        public Alo<T> decorate(Alo<T> alo) {
            return alo;
        }
    }
}

