/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.avro;

import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.atleon.util.TypeResolution;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.specific.SpecificData;

public final class AvroSchemas {
    private static final ObjectMapper OBJECT_MAPPER = AvroSchemas.createObjectMapper();

    private AvroSchemas() {
    }

    public static Schema removeJavaProperties(Schema schema) {
        try {
            JsonNode node = OBJECT_MAPPER.readTree(schema.toString());
            AvroSchemas.removeProperty(node, "avro.java.string");
            return AvroSchemas.createParser().parse(node.toString());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not parse schema: " + schema);
        }
    }

    public static Schema getOrReflectNullable(Object data) {
        return AvroSchemas.makeNullable(AvroSchemas.getOrReflect(data));
    }

    public static Schema getOrReflect(Object data) {
        return AvroSchemas.getOrSupply(data, () -> ReflectData.get().getSchema(data.getClass()));
    }

    public static Schema getOrSupply(Object data, Supplier<Schema> schemaSupplier) {
        try {
            return data instanceof GenericContainer ? ((GenericContainer)GenericContainer.class.cast(data)).getSchema() : SpecificData.get().getSchema((Type)TypeResolution.safelyGetClass((Object)data));
        }
        catch (AvroRuntimeException e) {
            return schemaSupplier.get();
        }
    }

    public static Schema makeNullable(Schema schema) {
        return AvroSchemas.isNull(schema) ? schema : ReflectData.makeNullable((Schema)schema);
    }

    public static Optional<Schema> reduceNonNull(Schema schema) {
        if (AvroSchemas.isUnion(schema)) {
            return schema.getTypes().stream().reduce((schema1, schema2) -> AvroSchemas.isNull(schema1) ? schema2 : schema1);
        }
        return AvroSchemas.isNull(schema) ? Optional.empty() : Optional.of(schema);
    }

    public static boolean isNullable(Schema schema) {
        return AvroSchemas.isUnion(schema) && schema.getTypes().stream().anyMatch(AvroSchemas::isNull);
    }

    public static boolean isUnion(Schema schema) {
        return schema.getType() == Schema.Type.UNION;
    }

    public static boolean isRecord(Schema schema) {
        return schema.getType() == Schema.Type.RECORD;
    }

    public static boolean isNull(Schema schema) {
        return schema.getType() == Schema.Type.NULL;
    }

    private static JsonMapper createObjectMapper() {
        return (JsonMapper)JsonMapper.builder().enable(new JsonReadFeature[]{JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS}).build();
    }

    private static Schema.Parser createParser() {
        Schema.Parser parser = new Schema.Parser();
        parser.setValidateDefaults(false);
        return parser;
    }

    private static void removeProperty(JsonNode node, String propertyName) {
        if (node.isObject()) {
            ((ObjectNode)ObjectNode.class.cast(node)).remove(propertyName);
        }
        if (node.isObject() || node.isArray()) {
            node.elements().forEachRemaining(element -> AvroSchemas.removeProperty(element, propertyName));
        }
    }
}

